package com.digiwin.athena.base.application.service.usermeta;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.application.meta.request.usermeta.MetadataConstant;
import com.digiwin.athena.base.application.meta.request.usermeta.UserMetadataItemReqDTO;
import com.digiwin.athena.base.application.meta.response.usermeta.UserMetadataItemRespDTO;
import com.digiwin.athena.base.infrastructure.manager.iam.service.BaseIamService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * UserMetadataServiceImpl Description
 *
 * @author majianfu
 * @date 2024/8/22
 * @since
 */
@Slf4j
@Service
public class UserMetadataServiceImpl implements UserMetadataService {
    private BaseIamService baseIamService;

    public UserMetadataServiceImpl(BaseIamService baseIamService) {
        this.baseIamService = baseIamService;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public List<UserMetadataItemRespDTO> queryBatchUserMessageSendType(UserMetadataItemReqDTO messageSendTypeReq, AuthoredUser authoredUser) {
        List<String> userIds = new ArrayList<>(null != messageSendTypeReq.getUserIds() ? messageSendTypeReq.getUserIds() : Lists.newArrayList());
        CollUtil.removeBlank(userIds);
        if (CollUtil.isEmpty(userIds)) {
            userIds.add(authoredUser.getUserId());
        }

        String tenantSid = messageSendTypeReq.getTenantSid();
        if (StringUtils.isBlank(tenantSid)) {
            tenantSid = String.valueOf(authoredUser.getTenantSid());
        }

        List<Map> userMetadataItems = baseIamService.batchQueryUserMetadataItem(userIds, tenantSid, MetadataConstant.MESSAGE_SEND_TYPE, MetadataConstant.CATALOG_ID_BASIC);//NOSONAR
        Map<String, Map> userMetadataItemMap = userMetadataItems.stream()//NOSONAR
                .collect(Collectors.toMap(map -> MapUtil.getStr(map, "userId", ""), Function.identity(), (oldValue, newValue) -> oldValue));//NOSONAR

        List<UserMetadataItemRespDTO> resultList = Lists.newArrayList();
        for (String userId : userIds) {
            Map metadataItem = userMetadataItemMap.get(userId);//NOSONAR

            String msgSendTypeVal = MapUtil.getStr(metadataItem, "value", MetadataConstant.MESSAGE_SEND_TYPE_IM);
            resultList.add(UserMetadataItemRespDTO.builder().userId(userId).value(msgSendTypeVal).build());
        }

        return resultList;
    }
}
