/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.attachment;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.Base64Converter;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.base.application.converter.DataConverter;
import com.digiwin.athena.base.application.manager.dmc.DmcService;
import com.digiwin.athena.base.application.meta.request.attachment.AttachUploadedCountDTO;
import com.digiwin.athena.base.application.meta.request.attachment.AttachmentDownloadReqDTO;
import com.digiwin.athena.base.application.meta.request.attachment.AttachmentReqDTO;
import com.digiwin.athena.base.application.meta.request.attachment.DeleteAttachmentReqDTO;
import com.digiwin.athena.base.application.meta.request.attachment.DmcAccount;
import com.digiwin.athena.base.application.meta.request.attachment.UploadOrDeleteAttachmentReqDTO;
import com.digiwin.athena.base.application.meta.request.attachment.UploadParamDTO;
import com.digiwin.athena.base.application.meta.response.attachment.AttachmentDownloadWatermarkRespDTO;
import com.digiwin.athena.base.application.meta.response.attachment.ShareAttachmentRespDTO;
import com.digiwin.athena.base.application.meta.response.attachment.UploadAttachmentRespDTO;
import com.digiwin.athena.base.application.service.attachment.AttachmentService;
import com.digiwin.athena.base.application.util.WatermarkUtil;
import com.digiwin.athena.base.application.util.ZipUtils;
import com.digiwin.athena.base.infrastructure.mapper.attachment.AttachmentMapper;
import com.digiwin.athena.base.sdk.aam.application.meta.request.QueryAttachmentReqDTO;
import com.digiwin.athena.base.sdk.aam.application.meta.response.AttachmentRespDTO;
import com.digiwin.athena.base.sdk.aam.application.service.QueryAttachmentService;
import com.digiwin.athena.base.sdk.aam.application.util.CommonUtils;
import com.digiwin.athena.base.sdk.aam.infrastructure.meta.po.AttachmentEntity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service(value="attachmentService")
public class AttachmentServiceImpl
implements AttachmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachmentServiceImpl.class);
    @Autowired
    private QueryAttachmentService queryAttachmentService;
    @Resource
    private AttachmentMapper attachmentMapper;
    @Resource
    private AttachmentServiceImpl attachmentService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private DmcService dmcService;
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Override
    public List<AttachmentRespDTO> queryByTaskIdAndRowDataKeyList(String tenantId, String taskId, String projectId, List<String> categories, List<String> rowDataKeyList) {
        return this.queryAttachmentService.queryByTaskIdAndRowDataKeyList(tenantId, taskId, projectId, categories, rowDataKeyList);
    }

    @Override
    public List<AttachmentRespDTO> queryByTaskIdAndRowDataKeyList(QueryAttachmentReqDTO queryAttachmentReqDTO) {
        return this.queryAttachmentService.queryByTaskIdAndRowDataKeyList(queryAttachmentReqDTO);
    }

    @Override
    @Transactional(transactionManager="baseAttachmentDataSourceTransactionManager")
    public void saveAttachment(AttachmentReqDTO attachmentFile) {
        log.info("saveAttachment, body:{}", (Object)attachmentFile);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        attachmentFile.setUploadUserId(authoredUser.getUserId());
        attachmentFile.setUploadUserName(authoredUser.getUserName());
        log.info("saveAttachment params: {}", (Object)attachmentFile);
        this.attachmentMapper.insert((Object)DataConverter.INSTANCE.toAttachmentEntity(attachmentFile));
    }

    private void saveAttachment(List<AttachmentReqDTO> uploadedList) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        for (AttachmentReqDTO attachmentFile : uploadedList) {
            attachmentFile.setUploadUserId(authoredUser.getUserId());
            attachmentFile.setUploadUserName(authoredUser.getUserName());
        }
        this.attachmentMapper.insertBatchSomeColumn((Collection)uploadedList.stream().map(attachmentReqDTO -> DataConverter.INSTANCE.toAttachmentEntity((AttachmentReqDTO)attachmentReqDTO)).collect(Collectors.toList()));
    }

    @Override
    @Transactional(transactionManager="baseAttachmentDataSourceTransactionManager")
    public void deleteAttachment(AttachmentReqDTO attachmentFile) {
        log.info("deleteAttachment, body:{}", (Object)attachmentFile);
        this.deleteAttachment(attachmentFile.getCategory(), attachmentFile.getCategoryId(), attachmentFile.getId());
    }

    private int deleteAttachment(String category, String categoryId, String id) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(StringUtils.isNotBlank((CharSequence)category), AttachmentEntity::getCategory, (Object)category)).eq(StringUtils.isNotBlank((CharSequence)categoryId), AttachmentEntity::getCategoryId, (Object)categoryId)).eq(AttachmentEntity::getId, (Object)id);
        return this.attachmentMapper.delete((Wrapper)wrapper);
    }

    private int deleteAttachment(String category, String categoryId, Collection<String> idList) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(StringUtils.isNotBlank((CharSequence)category), AttachmentEntity::getCategory, (Object)category)).eq(StringUtils.isNotBlank((CharSequence)categoryId), AttachmentEntity::getCategoryId, (Object)categoryId)).in(AttachmentEntity::getId, idList);
        return this.attachmentMapper.delete((Wrapper)wrapper);
    }

    @Override
    @Transactional(transactionManager="baseAttachmentDataSourceTransactionManager")
    public void uploadOrDeleteAttachment(UploadOrDeleteAttachmentReqDTO uploadOrDeleteAttachmentReqDTO) {
        log.info("uploadOrDeleteAttachment, body:{}", (Object)uploadOrDeleteAttachmentReqDTO);
        if (CollectionUtils.isNotEmpty(uploadOrDeleteAttachmentReqDTO.getUploadedFileList())) {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            for (AttachmentReqDTO attachmentReqDTO : uploadOrDeleteAttachmentReqDTO.getUploadedFileList()) {
                attachmentReqDTO.setUploadUserId(authoredUser.getUserId());
                attachmentReqDTO.setUploadUserName(authoredUser.getUserName());
            }
            this.attachmentService.saveAttachmentInNewTransaction(uploadOrDeleteAttachmentReqDTO.getUploadedFileList());
        }
        if (CollectionUtils.isNotEmpty(uploadOrDeleteAttachmentReqDTO.getDeletedFileList())) {
            Set<String> fileIdList = uploadOrDeleteAttachmentReqDTO.getDeletedFileList().stream().map(AttachmentReqDTO::getId).filter(id -> StringUtils.isNotBlank((CharSequence)id)).collect(Collectors.toSet());
            this.attachmentService.deleteAttachmentInNewTransaction(null, null, fileIdList);
            if (BooleanUtils.isTrue((Boolean)uploadOrDeleteAttachmentReqDTO.getNeedDeleteDmcFile())) {
                this.dmcService.loginAndDeleteAttachment(Collections.emptyList(), fileIdList, null);
            }
        }
    }

    @Override
    public void deleteAttachmentBatch(DeleteAttachmentReqDTO deleteAttachmentReqDTO) {
        log.info("deleteAttachmentBatch, body:{}", (Object)deleteAttachmentReqDTO);
        if (CollectionUtils.isNotEmpty(deleteAttachmentReqDTO.getDeleteFileList())) {
            List<AttachmentReqDTO> deleteFileList = deleteAttachmentReqDTO.getDeleteFileList();
            Map<String, DmcAccount> schemaDmcAccountReqDTOMap = deleteAttachmentReqDTO.getSchemaDmcAccountMap();
            if (MapUtils.isEmpty(schemaDmcAccountReqDTOMap)) {
                Set<String> fileIdList = deleteAttachmentReqDTO.getDeleteFileList().stream().map(AttachmentReqDTO::getId).filter(id -> StringUtils.isNotBlank((CharSequence)id)).collect(Collectors.toSet());
                this.dmcService.loginAndDeleteAttachment(Collections.emptyList(), fileIdList, null);
                return;
            }
            for (AttachmentReqDTO attachmentReqDTO : deleteFileList) {
                HashSet<String> fileIdList = new HashSet<String>();
                fileIdList.add(attachmentReqDTO.getId());
                DmcAccount DmcAccountReqDTO = schemaDmcAccountReqDTOMap.get(attachmentReqDTO.getTargetSchema());
                if (null == DmcAccountReqDTO) {
                    this.dmcService.loginAndDeleteAttachment(Collections.emptyList(), fileIdList, null);
                    continue;
                }
                AttachmentServiceImpl.encodeDmcAccountReqDTOPwd(DmcAccountReqDTO);
                AttachmentServiceImpl.encodeDmcAccountReqDTOPwdByHash(DmcAccountReqDTO);
                this.dmcService.loginAndDeleteAttachment(Collections.emptyList(), fileIdList, DmcAccountReqDTO);
            }
        }
    }

    private static void encodeDmcAccountReqDTOPwd(DmcAccount DmcAccountReqDTO) {
        if (null == DmcAccountReqDTO || !BooleanUtils.isTrue((Boolean)DmcAccountReqDTO.isPasswordAlreadyEncoded()) || StringUtils.isBlank((CharSequence)DmcAccountReqDTO.getPassword())) {
            return;
        }
        DmcAccountReqDTO.setPassword(Base64Converter.decode((String)DmcAccountReqDTO.getPassword()));
        DmcAccountReqDTO.setPasswordAlreadyEncoded(false);
    }

    private static void encodeDmcAccountReqDTOPwdByHash(DmcAccount DmcAccountReqDTO) {
        if (null == DmcAccountReqDTO || DmcAccountReqDTO.isPasswordAlreadyEncoded() || StringUtils.isBlank((CharSequence)DmcAccountReqDTO.getPassword())) {
            return;
        }
        DmcAccountReqDTO.setPassword(CommonUtils.sha256((String)DmcAccountReqDTO.getPassword(), (int)2));
        DmcAccountReqDTO.setPasswordAlreadyEncoded(true);
    }

    @Override
    public String uploadAttachmentByUrl(UploadParamDTO uploadParamDTO) {
        try {
            URL url = new URL(uploadParamDTO.getDownloadUrl());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(HttpMethod.GET.name());
            conn.setConnectTimeout(20000);
            conn.connect();
            uploadParamDTO.setInputStream(conn.getInputStream());
            if (uploadParamDTO.getInputStream().available() <= 0) {
                throw new RuntimeException();
            }
            if (StringUtils.isBlank((CharSequence)uploadParamDTO.getDownloadName())) {
                String headerField = conn.getHeaderField("Content-Disposition");
                if (headerField == null || !headerField.contains("filename=")) {
                    String fileName = url.getFile();
                    fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                    uploadParamDTO.setDownloadName(fileName);
                } else {
                    uploadParamDTO.setDownloadName(URLDecoder.decode(headerField.substring(headerField.lastIndexOf("filename=") + 9), "UTF-8").replaceAll("\"", ""));
                }
            }
        }
        catch (Exception e) {
            throw BusinessException.create((Integer)500, (String)"\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a,\u6587\u4ef6\u94fe\u63a5\u5931\u6548", (Throwable)ExceptionUtils.getRootCause((Throwable)e));
        }
        if (StringUtils.isBlank((CharSequence)uploadParamDTO.getExpireDate())) {
            LocalDateTime localDateTime = LocalDateTime.now().plusYears(1L);
            uploadParamDTO.setExpireDate(dateFormat.format(localDateTime));
        }
        Optional<ShareAttachmentRespDTO> shareAttachmentRespDTO = this.dmcService.uploadAndShareAttachment(uploadParamDTO);
        return shareAttachmentRespDTO.map(ShareAttachmentRespDTO::getUrl).orElse(null);
    }

    @Override
    public UploadAttachmentRespDTO uploadAgileReport(UploadParamDTO uploadParamDTO) {
        if (StringUtils.isEmpty((CharSequence)uploadParamDTO.getFileJson())) {
            return null;
        }
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(uploadParamDTO.getFileJson().getBytes());
            uploadParamDTO.setInputStream(inputStream);
            if (uploadParamDTO.getInputStream().available() <= 0) {
                throw new RuntimeException();
            }
            uploadParamDTO.setDownloadName(uploadParamDTO.getDownloadName() + ".json");
        }
        catch (Exception e) {
            throw BusinessException.create((Integer)500, (String)"\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a,\u6587\u4ef6\u94fe\u63a5\u5931\u6548", (Throwable)ExceptionUtils.getRootCause((Throwable)e));
        }
        return this.dmcService.uploadAttachment(uploadParamDTO);
    }

    @Override
    public Long attachUploadedCount(AttachUploadedCountDTO attachUploadedCountDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(AttachmentEntity::getRowDataKey, (Object)attachUploadedCountDTO.getRowDataKey())).in(AttachmentEntity::getCategory, attachUploadedCountDTO.getCategoryList())).eq(AttachmentEntity::getTenantId, (Object)attachUploadedCountDTO.getTenantId())).eq(StringUtils.isNotBlank((CharSequence)attachUploadedCountDTO.getTaskId()), AttachmentEntity::getTaskId, (Object)attachUploadedCountDTO.getTaskId())).eq(StringUtils.isNotBlank((CharSequence)attachUploadedCountDTO.getProjectId()), AttachmentEntity::getProjectId, (Object)attachUploadedCountDTO.getProjectId());
        return this.attachmentMapper.selectCount((Wrapper)queryWrapper);
    }

    @Override
    public boolean checkUploadCount(AttachmentReqDTO attachmentFile) {
        if (null != attachmentFile.getAllowCount() && attachmentFile.getCheckCount().booleanValue()) {
            AttachUploadedCountDTO attachUploadedCountDTO = AttachUploadedCountDTO.builder().rowDataKey(attachmentFile.getRowDataKey()).tenantId(attachmentFile.getTenantId()).taskId(attachmentFile.getTaskId()).projectId(attachmentFile.getProjectId()).categoryList(Collections.singletonList(attachmentFile.getCategory())).build();
            Long uploadedCount = this.attachUploadedCount(attachUploadedCountDTO);
            return uploadedCount >= attachmentFile.getAllowCount();
        }
        return false;
    }

    @Override
    public Map<String, Object> getFile(String fileId) {
        InputStream inputStream = this.dmcService.previewFile(fileId);
        try {
            String result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                return (Map)JsonUtils.jsonToObject((String)result, Map.class);
            }
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u654f\u6377\u62a5\u8868\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    @Override
    public Map<String, Object> deleteFile(String fileId) {
        return this.dmcService.deleteFile(fileId);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, transactionManager="baseAttachmentDataSourceTransactionManager")
    public void saveAttachmentInNewTransaction(List<AttachmentReqDTO> uploadedList) {
        this.saveAttachment(uploadedList);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, transactionManager="baseAttachmentDataSourceTransactionManager")
    public int deleteAttachmentInNewTransaction(String category, String categoryId, Collection<String> idList) {
        return this.deleteAttachment(category, categoryId, idList);
    }

    @Override
    public Object download(AttachmentDownloadReqDTO attachmentDownloadReqDTO) {
        this.checkDownloadContent(attachmentDownloadReqDTO);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        responseHeaders.setContentDispositionFormData("attachment", attachmentDownloadReqDTO.getFileName() + "." + attachmentDownloadReqDTO.getSuffixName());
        if (StringUtils.isNotBlank((CharSequence)attachmentDownloadReqDTO.getFileUrl())) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)this.drawingControl(attachmentDownloadReqDTO));
        }
        AttachmentDownloadReqDTO.DmcAccount dmcAccount = attachmentDownloadReqDTO.getDmcAccount();
        String token = this.getDmcToken(dmcAccount);
        ResponseEntity<byte[]> responseEntity = this.dmcService.getAttachment(attachmentDownloadReqDTO.getFileId(), token);
        if (Objects.isNull(responseEntity.getBody())) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(responseEntity);
        }
        byte[] bytes = this.convertToWatermark(attachmentDownloadReqDTO, (byte[])responseEntity.getBody());
        if (Objects.isNull(attachmentDownloadReqDTO.getSecurity()) || StringUtils.isBlank((CharSequence)attachmentDownloadReqDTO.getSecurity().getDefence())) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)bytes);
        }
        byte[] zipFile = this.convertToZip(attachmentDownloadReqDTO, bytes);
        responseHeaders.setContentDispositionFormData("attachment", attachmentDownloadReqDTO.getFileName() + ".zip");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)zipFile);
    }

    @Override
    public Object downloadImageWatermarkBase64(List<AttachmentDownloadReqDTO> attachmentDownloadReqDTOList) {
        ArrayList result = Lists.newArrayList();
        for (AttachmentDownloadReqDTO attachmentDownloadReqDTO : attachmentDownloadReqDTOList) {
            try {
                String fileId = attachmentDownloadReqDTO.getFileId();
                String fileUrl = attachmentDownloadReqDTO.getFileUrl();
                String suffixName = attachmentDownloadReqDTO.getSuffixName();
                String name = attachmentDownloadReqDTO.getName();
                Assert.isTrue((StringUtils.isNotBlank((CharSequence)fileId) || StringUtils.isNotBlank((CharSequence)fileUrl) ? 1 : 0) != 0, (String)"Parameter fileId fileUrl at least one is not empty");
                Assert.isTrue((StringUtils.isNotBlank((CharSequence)suffixName) || StringUtils.isNotBlank((CharSequence)name) ? 1 : 0) != 0, (String)"Parameter suffixName name at least one is not empty");
                if (StringUtils.isBlank((CharSequence)suffixName)) {
                    int lastDotIndex = name.lastIndexOf(46);
                    if (lastDotIndex == -1) {
                        throw new IllegalArgumentException("No file extension found");
                    }
                    suffixName = name.substring(lastDotIndex + 1).toLowerCase();
                    attachmentDownloadReqDTO.setSuffixName(suffixName);
                }
                AttachmentDownloadWatermarkRespDTO respDTO = new AttachmentDownloadWatermarkRespDTO();
                respDTO.setFileId(fileId);
                respDTO.setFileUrl(fileUrl);
                byte[] fileBytes = null;
                if (StringUtils.isNotBlank((CharSequence)fileUrl)) {
                    fileBytes = this.downloadImage(fileUrl);
                } else {
                    AttachmentDownloadReqDTO.DmcAccount dmcAccount = attachmentDownloadReqDTO.getDmcAccount();
                    String token = this.getDmcToken(dmcAccount);
                    ResponseEntity<byte[]> responseEntity = this.dmcService.getAttachment(attachmentDownloadReqDTO.getFileId(), token);
                    if (responseEntity != null && responseEntity.getBody() != null) {
                        fileBytes = (byte[])responseEntity.getBody();
                    }
                }
                if (fileBytes != null) {
                    byte[] watermarkedBytes = this.convertToWatermark(attachmentDownloadReqDTO, fileBytes);
                    String base64 = watermarkedBytes != null ? Base64.getEncoder().encodeToString(watermarkedBytes) : null;
                    String base64String = "data:image/" + attachmentDownloadReqDTO.getSuffixName() + ";base64," + base64;
                    respDTO.setBase64(base64String);
                }
                result.add(respDTO);
            }
            catch (Exception e) {
                String file = StringUtils.isNotBlank((CharSequence)attachmentDownloadReqDTO.getFileId()) ? attachmentDownloadReqDTO.getFileId() : attachmentDownloadReqDTO.getFileUrl();
                log.error("downloadWatermarkBase64 error processing file with file: {}", (Object)file, (Object)e);
            }
        }
        return result;
    }

    private byte[] convertToZip(AttachmentDownloadReqDTO attachmentDownloadReqDTO, byte[] fileBytes) {
        if (Objects.isNull(attachmentDownloadReqDTO.getSecurity()) || StringUtils.isBlank((CharSequence)attachmentDownloadReqDTO.getSecurity().getDefence())) {
            return fileBytes;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileBytes);
        try {
            fileBytes = ZipUtils.extracted(byteArrayInputStream, Base64Converter.decode((String)attachmentDownloadReqDTO.getSecurity().getDefence()), attachmentDownloadReqDTO.getFileName() + "." + attachmentDownloadReqDTO.getSuffixName());
        }
        catch (IOException e) {
            log.error("ZipUtils.extracted fileId:" + e.getMessage());
        }
        return fileBytes;
    }

    private void checkDownloadContent(AttachmentDownloadReqDTO attachmentDownloadReqDTO) {
        String fileId = attachmentDownloadReqDTO.getFileId();
        String fileUrl = attachmentDownloadReqDTO.getFileUrl();
        List<String> fileIds = attachmentDownloadReqDTO.getFileIds();
        Assert.hasText((String)attachmentDownloadReqDTO.getFileName(), (String)"Parameter fileName must not be null");
        Assert.hasText((String)attachmentDownloadReqDTO.getSuffixName(), (String)"Parameter suffixName must not be null");
        Assert.isTrue((CollectionUtils.isNotEmpty(fileIds) || StringUtils.isNotBlank((CharSequence)fileId) || StringUtils.isNotBlank((CharSequence)fileUrl) ? 1 : 0) != 0, (String)"Parameter fileIds fileId fileUrl at least one is not empty");
    }

    private byte[] convertToWatermark(AttachmentDownloadReqDTO attachmentDownloadReqDTO, byte[] file) {
        AttachmentDownloadReqDTO.Watermark watermark = attachmentDownloadReqDTO.getWatermark();
        boolean flag = Stream.of("jpg", "jpeg", "gif", "bmp", "png", "pic", "pdf").anyMatch(attachmentDownloadReqDTO.getSuffixName()::equalsIgnoreCase);
        if (Objects.isNull(watermark) || StringUtils.isBlank((CharSequence)watermark.getTopWatermarkText()) || !flag) {
            return file;
        }
        if ("pdf".equalsIgnoreCase(attachmentDownloadReqDTO.getSuffixName())) {
            try {
                return WatermarkUtil.addWatermarkPdf(file, watermark);
            }
            catch (Exception e) {
                log.error("WatermarkUtil.addWatermarkPdf failed:", (Throwable)e);
            }
        }
        try {
            return WatermarkUtil.addWatermarkImage(file, watermark, attachmentDownloadReqDTO.getSuffixName());
        }
        catch (Exception e) {
            log.error("WatermarkUtil.addWatermarkImage failed:", (Throwable)e);
            return file;
        }
    }

    private byte[] getKsc(String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<byte[]>(){}, new Object[0]);
            return (byte[])responseEntity.getBody();
        }
        catch (Exception ex) {
            log.error("ksc failed, url: {}", (Object)url, (Object)ex);
            throw BusinessException.create((String)("ksc failed, error: " + ex.getMessage()));
        }
    }

    private byte[] drawingControl(AttachmentDownloadReqDTO attachmentDownloadReqDTO) {
        String fileUrl = attachmentDownloadReqDTO.getFileUrl();
        byte[] ksc = this.getKsc(fileUrl);
        return this.convertToWatermark(attachmentDownloadReqDTO, ksc);
    }

    private String getDmcToken(AttachmentDownloadReqDTO.DmcAccount dmcAccount) {
        if (Objects.isNull(dmcAccount) || Objects.isNull(dmcAccount.getAccount()) || Objects.isNull(dmcAccount.getPassword())) {
            return this.dmcService.login(null, null);
        }
        String account = dmcAccount.getAccount();
        String password = dmcAccount.getPassword();
        Boolean isPasswordAlreadyEncoded = dmcAccount.getIsPasswordAlreadyEncoded();
        if (Objects.isNull(isPasswordAlreadyEncoded) || !isPasswordAlreadyEncoded.booleanValue()) {
            String decodePassword = Base64Converter.decode((String)dmcAccount.getPassword());
            password = CommonUtils.sha256((String)decodePassword, (int)2);
        }
        return this.dmcService.login(account, password);
    }

    private byte[] downloadImage(String imageUrl) {
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(imageUrl, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<byte[]>(){}, new Object[0]);
        return (byte[])responseEntity.getBody();
    }

    @Override
    public Object batchDownload(AttachmentDownloadReqDTO attachmentDownloadReqDTO) {
        String encodedFileName;
        this.checkDownloadContent(attachmentDownloadReqDTO);
        String fileName = attachmentDownloadReqDTO.getFileName() + "." + attachmentDownloadReqDTO.getSuffixName();
        try {
            encodedFileName = URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        responseHeaders.setContentDispositionFormData("attachment", encodedFileName);
        AttachmentDownloadReqDTO.DmcAccount dmcAccount = attachmentDownloadReqDTO.getDmcAccount();
        String token = this.getDmcToken(dmcAccount);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("fileId", null);
        param.put("fileIds", attachmentDownloadReqDTO.getFileIds());
        param.put("dirId", null);
        param.put("dirIds", null);
        byte[] zipFile = this.dmcService.getMultiAttachment(param, token);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)zipFile);
    }
}

