/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.commonused;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.meta.dto.commonused.ItemsDto;
import com.digiwin.athena.base.application.service.commonused.ItemService;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.ItemLogMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.ItemMapper;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.ItemData;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.ItemLogData;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemServiceImpl
implements ItemService {
    private static final Logger logger = LoggerFactory.getLogger(ItemServiceImpl.class);
    @Autowired
    private ItemMapper itemMapper;
    @Autowired
    private ItemLogMapper itemLogMapper;

    @Override
    public List<ItemData> queryItemList(AuthoredUser user, Integer plat, Long cateId) {
        QueryWrapper itemQuery = new QueryWrapper();
        if (cateId != null) {
            itemQuery.eq((Object)"cate_id", (Object)cateId);
        }
        itemQuery.eq((Object)"plat", (Object)plat);
        itemQuery.eq((Object)"tenant_id", (Object)user.getTenantId());
        itemQuery.eq((Object)"user_id", (Object)user.getUserId());
        return this.itemMapper.selectList((Wrapper)itemQuery);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public ItemData addItem(AuthoredUser user, ItemsDto itemsDto) {
        ItemData data = new ItemData();
        data.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        data.setPlat(itemsDto.getPlat());
        data.setCreateDate(LocalDateTime.now());
        data.setModifyDate(LocalDateTime.now());
        data.setItemCate(itemsDto.getItemCate());
        data.setItemCode(itemsDto.getItemCode());
        data.setCateId(itemsDto.getCateId());
        data.setUserId(user.getUserId());
        data.setUserName(user.getUserName());
        data.setTenantId(user.getTenantId());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"item_code", (Object)itemsDto.getItemCode());
        queryWrapper.eq((Object)"plat", (Object)itemsDto.getPlat());
        queryWrapper.eq((Object)"user_id", (Object)user.getUserId());
        queryWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        ItemData itemData = (ItemData)this.itemMapper.selectOne((Wrapper)queryWrapper);
        if (itemData != null) {
            return itemData;
        }
        int result = this.itemMapper.insert((Object)data);
        if (result > 0) {
            this.itemRecord(user, itemsDto, 1);
            return data;
        }
        return null;
    }

    public boolean isItemExist(AuthoredUser user, ItemsDto itemsDto) {
        QueryWrapper itemQuery = new QueryWrapper();
        itemQuery.eq((Object)"plat", (Object)itemsDto.getPlat());
        itemQuery.eq((Object)"item_code", (Object)itemsDto.getItemCode());
        itemQuery.eq((Object)"user_id", (Object)user.getUserId());
        itemQuery.eq((Object)"cate_id", (Object)itemsDto.getCateId());
        Long result = this.itemMapper.selectCount((Wrapper)itemQuery);
        return result > 0L;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int moveSingleItem(Long id, Long descCateId) {
        ItemData itemData = new ItemData();
        itemData.setCateId(descCateId);
        itemData.setModifyDate(LocalDateTime.now());
        UpdateWrapper itemWrapper = new UpdateWrapper();
        itemWrapper.eq((Object)"id", (Object)id);
        return this.itemMapper.update((Object)itemData, (Wrapper)itemWrapper);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int moveItemsByCate(Long srcCateId, Long descCateId, AuthoredUser user, int plat) {
        ItemData itemData = new ItemData();
        itemData.setCateId(descCateId);
        itemData.setModifyDate(LocalDateTime.now());
        UpdateWrapper itemWrapper = new UpdateWrapper();
        itemWrapper.eq((Object)"user_id", (Object)user.getUserId());
        itemWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        itemWrapper.eq((Object)"plat", (Object)plat);
        itemWrapper.eq((Object)"cate_id", (Object)srcCateId);
        return this.itemMapper.update((Object)itemData, (Wrapper)itemWrapper);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int deleteItemsByCate(Long srcCateId, AuthoredUser user, int plat) {
        ItemData itemData = new ItemData();
        itemData.setCateId(srcCateId);
        UpdateWrapper itemWrapper = new UpdateWrapper();
        itemWrapper.eq((Object)"user_id", (Object)user.getUserId());
        itemWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        itemWrapper.eq((Object)"plat", (Object)plat);
        itemWrapper.eq((Object)"cate_id", (Object)srcCateId);
        return this.itemMapper.delete((Wrapper)itemWrapper);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int delete(AuthoredUser user, Long id) {
        ItemData data = (ItemData)this.itemMapper.selectById((Serializable)id);
        boolean hasVal = false;
        if (null != data) {
            ItemsDto dto = new ItemsDto();
            BeanUtils.copyProperties((Object)data, (Object)dto);
            this.itemRecord(user, dto, 2);
            hasVal = true;
        }
        if (hasVal) {
            return this.itemMapper.deleteById((Serializable)id);
        }
        return 1;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int delete(AuthoredUser user, Integer plat, String itemCode) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"user_id", (Object)user.getUserId());
        query.eq((Object)"tenant_id", (Object)user.getTenantId());
        query.eq((Object)"item_code", (Object)itemCode);
        query.eq((Object)"plat", (Object)plat);
        ItemData data = (ItemData)this.itemMapper.selectOne((Wrapper)query);
        if (null != data) {
            ItemsDto dto = new ItemsDto();
            BeanUtils.copyProperties((Object)data, (Object)dto);
            this.itemRecord(user, dto, 2);
            return this.itemMapper.deleteById((Serializable)data.getId());
        }
        return 1;
    }

    @Override
    public ItemData detail(AuthoredUser user, String itemCode, Integer plat) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"plat", (Object)plat);
        query.eq((Object)"user_id", (Object)user.getUserId());
        query.eq((Object)"tenant_id", (Object)user.getTenantId());
        query.eq((Object)"item_code", (Object)itemCode);
        return (ItemData)this.itemMapper.selectOne((Wrapper)query);
    }

    @Override
    public boolean checkUsed(AuthoredUser user, Integer plat, String itemCode) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"plat", (Object)plat);
        query.eq((Object)"user_id", (Object)user.getUserId());
        query.eq((Object)"tenant_id", (Object)user.getTenantId());
        query.eq((Object)"item_code", (Object)itemCode);
        Long result = this.itemMapper.selectCount((Wrapper)query);
        return result > 0L;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int itemRecord(AuthoredUser user, ItemsDto itemDto, int type) {
        try {
            ItemLogData data = new ItemLogData();
            data.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
            data.setUserId(user.getUserId());
            data.setTenantId(user.getTenantId());
            data.setPlat(itemDto.getPlat());
            data.setCreateDate(LocalDateTime.now());
            data.setModifyDate(LocalDateTime.now());
            data.setItemCode(itemDto.getItemCode());
            data.setItemCate(itemDto.getItemCate());
            data.setType(Integer.valueOf(type));
            if (type == 0) {
                int autoResult = this.autoInUsed(user, itemDto);
                logger.debug("auto calc used result:" + autoResult);
            }
            int addResult = this.itemLogMapper.insert((Object)data);
            logger.debug("visit record add result:" + addResult);
            return addResult;
        }
        catch (Exception e) {
            logger.error("add item:[" + JsonUtils.objectToString((Object)itemDto) + "] record type:[" + type + "] error", (Throwable)e);
            return -1;
        }
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int autoInUsed(AuthoredUser user, ItemsDto itemDto) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"user_id", (Object)user.getUserId());
            queryWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
            queryWrapper.eq((Object)"item_code", (Object)itemDto.getItemCode());
            queryWrapper.eq((Object)"plat", (Object)itemDto.getPlat());
            queryWrapper.eq((Object)"type", (Object)2);
            Long result = this.itemLogMapper.selectCount((Wrapper)queryWrapper);
            if (result > 0L) {
                return -1;
            }
            QueryWrapper queryItemWrapper = new QueryWrapper();
            queryItemWrapper.eq((Object)"user_id", (Object)user.getUserId());
            queryItemWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
            queryItemWrapper.eq((Object)"item_code", (Object)itemDto.getItemCode());
            queryItemWrapper.eq((Object)"plat", (Object)itemDto.getPlat());
            Long itemExist = this.itemMapper.selectCount((Wrapper)queryItemWrapper);
            if (itemExist > 0L) {
                return -2;
            }
            QueryWrapper visitWapper = new QueryWrapper();
            visitWapper.eq((Object)"user_id", (Object)user.getUserId());
            visitWapper.eq((Object)"tenant_id", (Object)user.getTenantId());
            visitWapper.eq((Object)"item_code", (Object)itemDto.getItemCode());
            visitWapper.eq((Object)"plat", (Object)itemDto.getPlat());
            visitWapper.eq((Object)"type", (Object)0);
            LocalDateTime nowTime = LocalDateTime.now();
            visitWapper.and(vw -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)vw.between((Object)"create_date", (Object)nowTime.minusDays(3L), (Object)nowTime);
            });
            Long vistiResult = this.itemLogMapper.selectCount((Wrapper)visitWapper);
            if (vistiResult >= 2L) {
                ItemData resultData = this.addItem(user, itemDto);
                return null != resultData ? 1 : 0;
            }
            return -3;
        }
        catch (Exception e) {
            logger.error("auto add itemDto:[" + JsonUtils.objectToString((Object)itemDto) + "] error", (Throwable)e);
            return -4;
        }
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public boolean deleteItemLogByCreateTime(long weeks) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.lt(BaseEntity::getCreateDate, (Object)LocalDateTime.now().minusWeeks(weeks));
        int delete = this.itemLogMapper.delete((Wrapper)wrapper);
        if (delete < 1) {
            logger.error("delete itemlog error");
            return false;
        }
        return true;
    }
}

