/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.commonused;

import cn.hutool.core.io.resource.ResourceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.meta.dto.commonused.SystemMenuDTO;
import com.digiwin.athena.base.application.meta.dto.commonused.TmDataListDTO;
import com.digiwin.athena.base.application.meta.dto.commonused.TmDataTierListDTO;
import com.digiwin.athena.base.application.meta.request.commonused.MenuAuthorityReq;
import com.digiwin.athena.base.application.meta.response.commonused.MenuAuthorityResp;
import com.digiwin.athena.base.application.meta.response.commonused.MenuQueryResp;
import com.digiwin.athena.base.application.meta.response.commonused.MenuTopResp;
import com.digiwin.athena.base.application.meta.response.commonused.MenuUnFoldResp;
import com.digiwin.athena.base.application.service.commonused.CommonUsedService;
import com.digiwin.athena.base.application.service.commonused.MenuService;
import com.digiwin.athena.base.application.service.permission.PermissionCheckService;
import com.digiwin.athena.base.application.service.permission.PermissionService;
import com.digiwin.athena.base.application.service.permission.PermissionServiceImpl;
import com.digiwin.athena.base.infrastructure.manager.thememap.BaseThemeMapServiceImpl;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.BaseItemDto;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.MenuTopMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.MenuUnfoldMapper;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.MenuTopData;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.MenuUnfoldData;
import com.digiwin.athena.datamap.sdk.meta.dto.response.TmStartProjectDTO;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MenuServiceImpl
implements MenuService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MenuServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(MenuServiceImpl.class);
    private static final int TOP_STATUS = 1;
    @Autowired
    private MenuTopMapper menuTopMapper;
    @Autowired
    private MenuUnfoldMapper menuUnfoldMapper;
    @Autowired
    private PermissionCheckService permissionCheckService;
    @Autowired
    private CommonUsedService commonUsedService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private PermissionServiceImpl permissionServiceImpl;
    private static final String MODULE_START_PROJECT = "start-project";
    private static final String MODULE_BASIC_DATA = "athena-basicDataEntry";
    private static final String REPORT = "report";
    private static final String TYPE_BASE_DATA = "baseDataEntry";
    private static final String TYPE_START_PROJECT = "startProject";
    private static final String TYPE_SYS_MENU = "sysMenu";

    @Override
    public MenuQueryResp query(AuthoredUser user) {
        MenuQueryResp resp = new MenuQueryResp();
        resp.setTopInfo(this.menuTopQuery(user));
        resp.setUnfoldInfo(this.menuUnfoldQuery(user));
        return resp;
    }

    @Override
    public List<MenuTopResp> menuTopQuery(AuthoredUser user) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)user.getUserId());
        queryWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        List retData = this.menuTopMapper.selectList((Wrapper)queryWrapper);
        if (null == retData || retData.isEmpty()) {
            logger.debug("query user top:[" + user.getUserId() + "] menu is empty.");
            return new ArrayList<MenuTopResp>();
        }
        ArrayList<MenuTopResp> respList = new ArrayList<MenuTopResp>();
        for (MenuTopData menuData : retData) {
            MenuTopResp resp = new MenuTopResp();
            BeanUtils.copyProperties((Object)menuData, (Object)resp);
            respList.add(resp);
        }
        return respList;
    }

    @Override
    public List<MenuUnFoldResp> menuUnfoldQuery(AuthoredUser user) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)user.getUserId());
        queryWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        List retData = this.menuUnfoldMapper.selectList((Wrapper)queryWrapper);
        if (null == retData || retData.isEmpty()) {
            logger.debug("query user unfold:[" + user.getUserId() + "] menu is empty.");
            return new ArrayList<MenuUnFoldResp>();
        }
        ArrayList<MenuUnFoldResp> respList = new ArrayList<MenuUnFoldResp>();
        for (MenuUnfoldData menuData : retData) {
            MenuUnFoldResp resp = new MenuUnFoldResp();
            BeanUtils.copyProperties((Object)menuData, (Object)resp);
            respList.add(resp);
        }
        return respList;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public boolean setMenuTop(AuthoredUser user, String moduleNo) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"user_id", (Object)user.getUserId());
        updateWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        this.menuTopMapper.delete((Wrapper)updateWrapper);
        MenuTopData addData = new MenuTopData();
        addData.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        addData.setIsTop(Integer.valueOf(1));
        addData.setUserId(user.getUserId());
        addData.setTenantId(user.getTenantId());
        addData.setCreateDate(LocalDateTime.now());
        addData.setModifyDate(LocalDateTime.now());
        addData.setModuleNo(moduleNo);
        int result = this.menuTopMapper.insert((Object)addData);
        return result >= 1;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public boolean setMenuUnfold(AuthoredUser user, String moduleNo, Integer flag) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"user_id", (Object)user.getUserId());
        updateWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        this.menuUnfoldMapper.delete((Wrapper)updateWrapper);
        MenuUnfoldData addData = new MenuUnfoldData();
        addData.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        addData.setUnfold(flag);
        addData.setUserId(user.getUserId());
        addData.setTenantId(user.getTenantId());
        addData.setCreateDate(LocalDateTime.now());
        addData.setModifyDate(LocalDateTime.now());
        addData.setModuleNo(moduleNo);
        int result = this.menuUnfoldMapper.insert((Object)addData);
        return result >= 1;
    }

    @Override
    public List<SystemMenuDTO> getAllSystemMenus() {
        String menuData = ResourceUtil.readUtf8Str((String)"data/systemMenus.json");
        return JsonUtils.jsonToListObject((String)menuData, SystemMenuDTO.class);
    }

    @Override
    public List<MenuAuthorityResp> getAuthorityMenu(AuthoredUser user) {
        ArrayList<MenuAuthorityResp> resultList;
        block2: {
            Map<String, List<String>> permissionMap = this.permissionCheckService.getModuleOrMenuAccessible(user, "Athena");
            ArrayList allPermissionModules = permissionMap.containsKey("allModule") ? permissionMap.get("allModule") : Lists.newArrayList();
            ArrayList allPermissionMenus = permissionMap.containsKey("allMenu") ? permissionMap.get("allMenu") : Lists.newArrayList();
            ArrayList accessibleModules = permissionMap.containsKey("accessibleModule") ? permissionMap.get("accessibleModule") : Lists.newArrayList();
            ArrayList accessibleMenus = permissionMap.containsKey("accessibleMenu") ? permissionMap.get("accessibleMenu") : Lists.newArrayList();
            String sysMenuData = ResourceUtil.readUtf8Str((String)"data/systemMenus.json");
            List systemMenuDataList = JsonUtils.jsonToListObject((String)sysMenuData, SystemMenuDTO.class);
            this.getAccessibleModules(allPermissionModules, accessibleModules, systemMenuDataList);
            resultList = new ArrayList<MenuAuthorityResp>();
            CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> this.getAccessibleSysMenus(resultList, systemMenuDataList, accessibleModules, accessibleMenus, allPermissionMenus));
            CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> this.getAllowStartProjects(resultList, user, accessibleModules, Boolean.TRUE, null));
            CompletableFuture<Void> future3 = CompletableFuture.runAsync(() -> this.getAllowBaseDataEntries(resultList, user, accessibleModules, Boolean.TRUE, null));
            CompletableFuture<Void> future4 = CompletableFuture.runAsync(() -> this.getAllowReports(resultList, user, accessibleModules, Boolean.TRUE, null));
            CompletableFuture<Void> allOf = CompletableFuture.allOf(future1, future2, future3, future4);
            try {
                allOf.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                if (!(e instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
        return resultList;
    }

    private void getAccessibleModules(List<String> allPermissionModules, List<String> accessibleModules, List<SystemMenuDTO> systemMenuDTOS) {
        List allModuleList = systemMenuDTOS.stream().map(SystemMenuDTO::getModuleId).collect(Collectors.toList());
        allModuleList.addAll(Arrays.asList(MODULE_START_PROJECT, MODULE_BASIC_DATA, REPORT));
        accessibleModules.addAll(allModuleList.stream().filter(item -> !allPermissionModules.contains(item)).collect(Collectors.toList()));
    }

    private void getAccessibleSysMenus(List<MenuAuthorityResp> resultList, List<SystemMenuDTO> systemMenuDataList, List<String> accessibleModules, List<String> accessibleMenus, List<String> allPermissionMenus) {
        ArrayList<SystemMenuDTO> allSystemMenus = new ArrayList<SystemMenuDTO>();
        this.getSystemMenu(systemMenuDataList, allSystemMenus);
        for (SystemMenuDTO systemMenu : allSystemMenus) {
            if (!accessibleModules.contains(systemMenu.getModuleId()) || !accessibleMenus.contains(systemMenu.getCode()) && allPermissionMenus.contains(systemMenu.getCode())) continue;
            MenuAuthorityResp resp = new MenuAuthorityResp();
            resp.setCode(systemMenu.getCode());
            resp.setType(TYPE_SYS_MENU);
            resultList.add(resp);
        }
    }

    private void getSystemMenu(List<SystemMenuDTO> systemMenuTrees, List<SystemMenuDTO> systemMenuList) {
        for (SystemMenuDTO systemMenuDTO : systemMenuTrees) {
            if (CollectionUtils.isNotEmpty(systemMenuDTO.getSubMenus())) {
                this.getSystemMenu(systemMenuDTO.getSubMenus(), systemMenuList);
                continue;
            }
            if (systemMenuDTO.getIsDirectory().booleanValue()) continue;
            systemMenuList.add(systemMenuDTO);
        }
    }

    private void getAllowStartProjects(List<MenuAuthorityResp> resultList, AuthoredUser user, List<String> accessibleModules, Boolean needSearchStartProject, List<Map<String, Object>> startProjectJobList) {
        if (!accessibleModules.contains(MODULE_START_PROJECT)) {
            return;
        }
        List startProjects = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(startProjectJobList), TmStartProjectDTO.class);
        List<TmStartProjectDTO> startProjectList = this.commonUsedService.startProjectList(user, needSearchStartProject, startProjects);
        this.getStartProject(startProjectList, resultList);
    }

    private void getAllowBaseDataEntries(List<MenuAuthorityResp> resultList, AuthoredUser user, List<String> accessibleModules, Boolean searchData, List<BaseItemDto> baseDataEntryJobList) {
        if (!accessibleModules.contains(MODULE_BASIC_DATA)) {
            return;
        }
        List<TmDataListDTO> basicDataList = this.commonUsedService.tmDataList(user, BaseThemeMapServiceImpl.BASE_DATA_PLAT, false, searchData, baseDataEntryJobList, null, "allow");
        this.getBasicDataOrReport(basicDataList, resultList, BaseThemeMapServiceImpl.BASE_DATA_PLAT);
    }

    private void getAllowReports(List<MenuAuthorityResp> resultList, AuthoredUser user, List<String> accessibleModules, Boolean searchData, List<BaseItemDto> reportJobList) {
        if (!accessibleModules.contains(REPORT)) {
            return;
        }
        List<TmDataListDTO> reportList = this.commonUsedService.tmDataList(user, BaseThemeMapServiceImpl.REPORT_PLAT, false, searchData, reportJobList, null, "allow");
        this.getBasicDataOrReport(reportList, resultList, BaseThemeMapServiceImpl.REPORT_PLAT);
    }

    private void getBasicDataOrReport(List<TmDataListDTO> dataListDTOS, List<MenuAuthorityResp> accessibleData, Integer plat) {
        for (TmDataListDTO tmDataListDTO : dataListDTOS) {
            if (CollectionUtils.isNotEmpty(tmDataListDTO.getGroupList())) {
                for (TmDataTierListDTO group : tmDataListDTO.getGroupList()) {
                    this.getChildrenBasicDataOrReport(group.getBaseItemDtoList(), accessibleData, plat);
                }
            }
            if (!CollectionUtils.isNotEmpty(tmDataListDTO.getBaseItemDtoList())) continue;
            this.getChildrenBasicDataOrReport(tmDataListDTO.getBaseItemDtoList(), accessibleData, plat);
        }
    }

    private void getChildrenBasicDataOrReport(List<BaseItemDto> baseItemDtoList, List<MenuAuthorityResp> accessibleData, Integer plat) {
        for (BaseItemDto baseItemDto : baseItemDtoList) {
            if (!"allow".equalsIgnoreCase(baseItemDto.getAccess())) continue;
            MenuAuthorityResp resp = new MenuAuthorityResp();
            resp.setCode(baseItemDto.getCode());
            resp.setType(0 == plat ? TYPE_BASE_DATA : REPORT);
            accessibleData.add(resp);
        }
    }

    private void getStartProject(List<TmStartProjectDTO> startProjectList, List<MenuAuthorityResp> resultList) {
        if (CollectionUtils.isEmpty(startProjectList)) {
            return;
        }
        for (TmStartProjectDTO startProject : startProjectList) {
            MenuAuthorityResp resp = new MenuAuthorityResp();
            resp.setCode(startProject.getCode());
            resp.setType(TYPE_START_PROJECT);
            resultList.add(resp);
        }
    }

    @Override
    public List<MenuAuthorityResp> getAuthorityMenu(AuthoredUser user, List<MenuAuthorityReq> allMenuList) {
        log.info("allMenuList:{}", (Object)JsonUtils.objectToString(allMenuList));
        if (CollectionUtils.isEmpty(allMenuList)) {
            return Lists.newArrayList();
        }
        ArrayList<String> appCodes = new ArrayList<String>();
        HashMap<String, List<Map<String, Object>>> allMenuMap = new HashMap<String, List<Map<String, Object>>>();
        this.dealMenus(allMenuList, appCodes, allMenuMap, user);
        appCodes.add("Athena");
        this.permissionService.batchGetAppAccessible(user, appCodes);
        Map<String, List<String>> permissionMap = this.permissionCheckService.getModuleOrMenuAccessible(user, "Athena");
        ArrayList allPermissionModules = permissionMap.containsKey("allModule") ? permissionMap.get("allModule") : Lists.newArrayList();
        ArrayList allPermissionMenus = permissionMap.containsKey("allMenu") ? permissionMap.get("allMenu") : Lists.newArrayList();
        ArrayList accessibleModules = permissionMap.containsKey("accessibleModule") ? permissionMap.get("accessibleModule") : Lists.newArrayList();
        ArrayList accessibleMenus = permissionMap.containsKey("accessibleMenu") ? permissionMap.get("accessibleMenu") : Lists.newArrayList();
        String sysMenuData = ResourceUtil.readUtf8Str((String)"data/systemMenus.json");
        List systemMenuDataList = JsonUtils.jsonToListObject((String)sysMenuData, SystemMenuDTO.class);
        this.getAccessibleModules(allPermissionModules, accessibleModules, systemMenuDataList);
        ArrayList<MenuAuthorityResp> resultList = new ArrayList<MenuAuthorityResp>();
        CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> {
            AppAuthContextHolder.getContext().setAuthoredUser(user);
            this.getAccessibleSysMenus(resultList, systemMenuDataList, accessibleModules, accessibleMenus, allPermissionMenus);
        });
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
            AppAuthContextHolder.getContext().setAuthoredUser(user);
            this.getAllowStartProjects(resultList, user, accessibleModules, Boolean.FALSE, (List)allMenuMap.get(TYPE_START_PROJECT));
        });
        CompletableFuture<Void> future3 = CompletableFuture.runAsync(() -> {
            AppAuthContextHolder.getContext().setAuthoredUser(user);
            this.getAllowBaseDataEntries(resultList, user, accessibleModules, Boolean.FALSE, JsonUtils.jsonToListObject((String)JsonUtils.objectToString(allMenuMap.get(TYPE_BASE_DATA)), BaseItemDto.class));
        });
        CompletableFuture<Void> future4 = CompletableFuture.runAsync(() -> {
            AppAuthContextHolder.getContext().setAuthoredUser(user);
            this.getAllowReports(resultList, user, accessibleModules, Boolean.FALSE, JsonUtils.jsonToListObject((String)JsonUtils.objectToString(allMenuMap.get(REPORT)), BaseItemDto.class));
        });
        CompletableFuture<Void> allOf = CompletableFuture.allOf(future1, future2, future3, future4);
        try {
            allOf.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return resultList;
    }

    private void dealMenus(List<MenuAuthorityReq> allMenuList, List<String> appCodes, Map<String, List<Map<String, Object>>> allMenuMap, AuthoredUser user) {
        ArrayList sysMenuList = new ArrayList();
        ArrayList startProjectList = new ArrayList();
        ArrayList baseDataEntryList = new ArrayList();
        ArrayList reportList = new ArrayList();
        List<String> authorityAppCodes = this.permissionServiceImpl.getUserAuthoredAppCode(user.getToken());
        if (CollectionUtils.isEmpty(authorityAppCodes)) {
            return;
        }
        for (MenuAuthorityReq menuAuthorityReq : allMenuList) {
            if (!authorityAppCodes.contains(menuAuthorityReq.getAppCode())) continue;
            appCodes.add(menuAuthorityReq.getAppCode());
            List<MenuAuthorityReq.JobCode> jobCodeList = menuAuthorityReq.getJobCodeList();
            if (CollectionUtils.isEmpty(jobCodeList)) continue;
            for (MenuAuthorityReq.JobCode jobCode : jobCodeList) {
                HashMap<String, String> menuMap;
                if (TYPE_SYS_MENU.equals(jobCode.getType())) {
                    menuMap = new HashMap<String, String>();
                    menuMap.put("code", jobCode.getCode());
                    menuMap.put("appCode", menuAuthorityReq.getAppCode());
                    sysMenuList.add(menuMap);
                }
                if (TYPE_START_PROJECT.equals(jobCode.getType())) {
                    menuMap = new HashMap();
                    menuMap.put("code", jobCode.getCode());
                    menuMap.put("appCode", menuAuthorityReq.getAppCode());
                    startProjectList.add(menuMap);
                }
                if (TYPE_BASE_DATA.equals(jobCode.getType())) {
                    menuMap = new HashMap();
                    menuMap.put("code", jobCode.getCode());
                    menuMap.put("appCode", menuAuthorityReq.getAppCode());
                    baseDataEntryList.add(menuMap);
                }
                if (!REPORT.equals(jobCode.getType())) continue;
                menuMap = new HashMap();
                menuMap.put("code", jobCode.getCode());
                menuMap.put("appCode", menuAuthorityReq.getAppCode());
                reportList.add(menuMap);
            }
        }
        allMenuMap.put(TYPE_SYS_MENU, sysMenuList);
        allMenuMap.put(TYPE_START_PROJECT, startProjectList);
        allMenuMap.put(TYPE_BASE_DATA, baseDataEntryList);
        allMenuMap.put(REPORT, reportList);
    }
}

