/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.trial;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.exception.OperateException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.meta.request.trial.apply.AcpReq;
import com.digiwin.athena.base.application.meta.request.trial.apply.ProductInfo;
import com.digiwin.athena.base.application.meta.request.trial.apply.TrialApplyReq;
import com.digiwin.athena.base.application.service.trial.TrialApplyService;
import com.digiwin.athena.base.infrastructure.manager.emc.BaseSendEmailService;
import com.digiwin.athena.base.infrastructure.mapper.audc.trial.TrialApplyMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.trial.TrialConfigMapper;
import com.digiwin.athena.base.infrastructure.meta.po.trial.TrialApplyData;
import com.digiwin.athena.base.infrastructure.meta.po.trial.TrialConfigData;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class TrialApplyServiceImpl
implements TrialApplyService {
    private static final Logger logger = LoggerFactory.getLogger(TrialApplyServiceImpl.class);
    private static final String TRIAL_AUDIT_RECEIVER_DAFAULT = "gonghx@digiwin.com";
    private static final String TRAIL_EMAIL_TEMPLATE_DEFAULT = "ATHENA_TRIAL_INFORMATION_APPLY_ZH_CN";
    private static final String ACP_APP_KEY = "brHxX3zqb24ngOphHJ8t6AHrqksR48X1AhUC9egqFE";
    private static final String ACP_URL = "http://misws.digiwin.com/miswsAPI//ServiceForAthena.asmx/AthenaGetACPdata";
    private static final String USER_AREA = "USER_AREA";
    private static final String USE_ACP_FLAG = "USE_ACP_FLAG";
    private static final String TAIWAN_SIMPLE = "TW";
    private final TrialApplyMapper trialApplyMapper;
    private final BaseSendEmailService baseSendEmailService;
    private final TrialConfigMapper trialConfigMapper;
    private final RestTemplate restTemplate;

    @Autowired
    public TrialApplyServiceImpl(TrialApplyMapper trialApplyMapper, BaseSendEmailService baseSendEmailService, TrialConfigMapper trialConfigMapper, RestTemplate restTemplate) {
        this.trialApplyMapper = trialApplyMapper;
        this.baseSendEmailService = baseSendEmailService;
        this.trialConfigMapper = trialConfigMapper;
        this.restTemplate = restTemplate;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int insert(TrialApplyData data) {
        data.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        data.setCreateDate(LocalDateTime.now());
        data.setModifyDate(LocalDateTime.now());
        return this.trialApplyMapper.insert((Object)data);
    }

    @Override
    public boolean isExist(String phone, String productCode) {
        QueryWrapper countWrapper = new QueryWrapper();
        countWrapper.eq((Object)"phone", (Object)phone);
        countWrapper.eq((Object)"product_code", (Object)productCode);
        Long result = this.trialApplyMapper.selectCount((Wrapper)countWrapper);
        return result > 0L;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int dealApplyInfo(TrialApplyReq req) {
        TrialApplyData data = new TrialApplyData();
        BeanUtils.copyProperties((Object)req, (Object)data);
        data.setFaq(JsonUtils.objectToString(req.getFaqList()));
        List<ProductInfo> productList = req.getProductList();
        data.setProductInfo(JsonUtils.objectToString(productList));
        int result = this.insert(data);
        if (result <= 0) {
            throw BusinessException.create((Integer)-1, (String)"Submit Apply Info Error");
        }
        new Thread(() -> {
            logger.info("Query custom :[" + req.getEmail() + "] with server:[custom server]");
            List<String> serverList = this.queryServerMail(req);
            logger.info("Service Recevier info:" + JsonUtils.objectToString(serverList));
            String trialAuditor = this.queryAuditEmail();
            serverList.add(trialAuditor);
            String receivers = org.apache.commons.lang3.StringUtils.join((Object[])serverList.toArray(), (String)";");
            String templateId = this.queryMailTemplateId();
            Map<String, Object> sendMailParams = this.packageSendParam(req);
            try {
                this.baseSendEmailService.sendEmailWithTemplate(templateId, receivers, sendMailParams);
            }
            catch (Exception e) {
                logger.error("send supply info error with:" + req, (Throwable)e);
                throw BusinessException.create((Integer)-2, (String)"Send Apply Mail To Worker Error");
            }
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)data.getId())).set((Object)"recInfo", (Object)receivers);
            this.trialApplyMapper.update((Object)data, (Wrapper)updateWrapper);
        }, "Thread-Request-ACP").start();
        return 0;
    }

    private Map<String, Object> packageSendParam(TrialApplyReq req) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("company", req.getCompany());
        params.put("phone", req.getPhone());
        params.put("email", req.getEmail());
        params.put("faqList", req.getFaqList());
        params.put("productList", req.getProductList());
        return params;
    }

    private String queryAuditEmail() {
        String receiver = "TRIAL_AUDIT_RECEIVER";
        QueryWrapper trialQuery1 = new QueryWrapper();
        trialQuery1.eq((Object)"conf_key", (Object)receiver);
        TrialConfigData data1 = (TrialConfigData)this.trialConfigMapper.selectOne((Wrapper)trialQuery1);
        return StringUtils.isEmpty((Object)data1.getConfVal()) ? TRIAL_AUDIT_RECEIVER_DAFAULT : data1.getConfVal();
    }

    private String queryMailTemplateId() {
        String templatePrefix = "TRAIL_EMAIL_TEMPLATE";
        String local = LocaleContextHolder.getLocale().toString();
        if (!StringUtils.isEmpty((Object)local) && local.equalsIgnoreCase("zh_TW")) {
            local = "_ZH_TW";
        }
        local = !StringUtils.isEmpty((Object)local) && local.equalsIgnoreCase("en_US") ? "_EN_US" : "_ZH_CN";
        String templateId = templatePrefix + local;
        QueryWrapper trialQuery = new QueryWrapper();
        trialQuery.eq((Object)"conf_key", (Object)templateId);
        TrialConfigData data = (TrialConfigData)this.trialConfigMapper.selectOne((Wrapper)trialQuery);
        return StringUtils.isEmpty((Object)data.getConfVal()) ? TRAIL_EMAIL_TEMPLATE_DEFAULT : data.getConfVal();
    }

    private List<String> queryServerMail(TrialApplyReq req) {
        JSONObject acpRet;
        QueryWrapper areaQuery = new QueryWrapper();
        areaQuery.eq((Object)"conf_key", (Object)USE_ACP_FLAG);
        TrialConfigData acpFlagData = (TrialConfigData)this.trialConfigMapper.selectOne((Wrapper)areaQuery);
        if (acpFlagData == null || StringUtils.isEmpty((Object)acpFlagData.getConfVal()) || !"true".equals(acpFlagData.getConfVal())) {
            logger.info("Not Config ACP USER_ACP_FLAG");
            return new ArrayList<String>();
        }
        AcpReq acpReq = new AcpReq();
        String area = this.queryUserArea();
        acpReq.setArea(area);
        acpReq.setEmail(req.getEmail());
        acpReq.setPhone(req.getPhone());
        acpReq.setCustName(req.getCompany());
        acpReq.setAppkey(ACP_APP_KEY);
        acpReq.setPK("AI PK INFO");
        String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        acpReq.setAppsecret(DigestUtils.md5DigestAsHex((byte[])(ACP_APP_KEY + dateStr).getBytes()).toLowerCase());
        try {
            acpRet = this.sendToAcp(acpReq);
        }
        catch (Exception e) {
            logger.error("query result from acp error", (Throwable)e);
            acpRet = new JSONObject();
        }
        return this.paresServers(acpRet);
    }

    private String queryUserArea() {
        TrialConfigData areaData;
        QueryWrapper areaQuery = new QueryWrapper();
        areaQuery.eq((Object)"conf_key", (Object)USER_AREA);
        try {
            areaData = (TrialConfigData)this.trialConfigMapper.selectOne((Wrapper)areaQuery);
        }
        catch (Exception e) {
            logger.error("Query USER_AREA error,ready to use default", (Throwable)e);
            return TAIWAN_SIMPLE;
        }
        if (null == areaData) {
            logger.error("Query USER_AREA not Config,ready to use default");
            return TAIWAN_SIMPLE;
        }
        return areaData.getConfVal();
    }

    private JSONObject sendToAcp(AcpReq acpReq) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.TEXT_PLAIN);
            HttpEntity httpEntity = new HttpEntity((Object)JsonUtils.objectToString((Object)acpReq), (MultiValueMap)headers);
            ResponseEntity respEntity = this.restTemplate.exchange(ACP_URL, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue()) {
                if (null == respEntity.getBody()) {
                    throw new OperateException("status code:[ 200 ],but no data returned");
                }
                return (JSONObject)respEntity.getBody();
            }
            throw new OperateException(Integer.valueOf(respEntity.getStatusCodeValue()), String.valueOf(respEntity.getBody()));
        }
        catch (Exception ex) {
            throw new OperateException("Query ACP failed, exception: " + ex.getMessage());
        }
    }

    private List<String> paresServers(JSONObject jsonObject) {
        if (jsonObject != null && jsonObject.containsKey((Object)"code")) {
            if (jsonObject.getInt("code") == 0) {
                logger.error("can not find server");
                throw BusinessException.create((Integer)-1, (String)"find acp server error");
            }
            if (jsonObject.containsKey((Object)"sales")) {
                JSONArray sales = jsonObject.getJSONArray("sales");
                return this.parseServerEmail(sales);
            }
            if (jsonObject.containsKey((Object)"manager")) {
                JSONArray manager = jsonObject.getJSONArray("manager");
                return this.parseServerEmail(manager);
            }
            if (jsonObject.containsKey((Object)"GM")) {
                JSONArray gm = jsonObject.getJSONArray("GM");
                return this.parseServerEmail(gm);
            }
            if (jsonObject.containsKey((Object)"market")) {
                JSONArray market = jsonObject.getJSONArray("market");
                return this.parseServerEmail(market);
            }
            throw BusinessException.create((Integer)-1, (String)"Acp no right servers return");
        }
        return new ArrayList<String>();
    }

    private List<String> parseServerEmail(JSONArray jsonArray) {
        ArrayList<String> emailList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            String mail;
            JSONObject object = jsonArray.getJSONObject(i);
            if (object == null || !object.containsKey((Object)"mail") || StringUtils.isEmpty((Object)(mail = object.getString("mail")))) continue;
            emailList.add(mail);
        }
        return emailList;
    }
}

