/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.trial;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.meta.request.trial.scene.TrialSceneReq;
import com.digiwin.athena.base.application.meta.request.trial.scene.TrialSceneResp;
import com.digiwin.athena.base.application.meta.request.trial.userScene.TrailUserSceneBindReq;
import com.digiwin.athena.base.application.meta.request.trial.userScene.TrialUserSceneReq;
import com.digiwin.athena.base.application.meta.request.trial.userScene.TrialUserSceneResp;
import com.digiwin.athena.base.application.service.trial.TrialSceneService;
import com.digiwin.athena.base.application.service.trial.TrialUserSceneService;
import com.digiwin.athena.base.infrastructure.mapper.audc.trial.TrialUserSceneMapper;
import com.digiwin.athena.base.infrastructure.meta.po.trial.TrialUserSceneData;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TrialUserSceneServiceImpl
implements TrialUserSceneService {
    private final TrialUserSceneMapper trialUserSceneMapper;
    private final TrialSceneService trialSceneService;

    @Autowired
    public TrialUserSceneServiceImpl(TrialUserSceneMapper trialUserSceneMapper, TrialSceneService trialSceneService) {
        this.trialUserSceneMapper = trialUserSceneMapper;
        this.trialSceneService = trialSceneService;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int add(TrialUserSceneReq req) {
        TrialUserSceneData data = new TrialUserSceneData();
        BeanUtils.copyProperties((Object)req, (Object)data);
        data.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        data.setCreateDate(LocalDateTime.now());
        data.setModifyDate(LocalDateTime.now());
        return this.trialUserSceneMapper.insert((Object)data);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int modify(TrialUserSceneReq data) {
        TrialUserSceneData userSceneData = new TrialUserSceneData();
        userSceneData.setId(data.getId());
        userSceneData.setModifyDate(LocalDateTime.now());
        userSceneData.setRank(data.getRank());
        return this.trialUserSceneMapper.updateById((Object)userSceneData);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int delete(Long id) {
        return this.trialUserSceneMapper.deleteById((Serializable)id);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public void bindScenes(TrailUserSceneBindReq req) {
        List<Map<String, Object>> scenes = req.getScenes();
        if (scenes != null && !scenes.isEmpty()) {
            UpdateWrapper delWrapper = new UpdateWrapper();
            delWrapper.eq((Object)"user_id", (Object)req.getUserId());
            delWrapper.eq((Object)"tenant_id", (Object)req.getTenantId());
            delWrapper.eq((Object)"app_code", (Object)req.getRoleId());
            this.trialUserSceneMapper.delete((Wrapper)delWrapper);
            scenes.forEach(x -> {
                TrialUserSceneData data = new TrialUserSceneData();
                BeanUtils.copyProperties((Object)req, (Object)data);
                data.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
                data.setSceneId(Long.valueOf(MapUtils.getLongValue((Map)x, (Object)"sceneId")));
                data.setRank(Integer.valueOf(MapUtils.getIntValue((Map)x, (Object)"rank")));
                data.setSceneKey(MapUtils.getString((Map)x, (Object)"sceneKey"));
                data.setCreateDate(LocalDateTime.now());
                data.setModifyDate(LocalDateTime.now());
                this.trialUserSceneMapper.insert((Object)data);
            });
        }
    }

    @Override
    public TrialUserSceneResp listWithScenes(TrailUserSceneBindReq req) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"user_id", (Object)req.getUserId());
        wrapper.eq((Object)"tenant_id", (Object)req.getTenantId());
        wrapper.eq((Object)"app_code", (Object)req.getAppCode());
        List userSceneList = this.trialUserSceneMapper.selectList((Wrapper)wrapper);
        TrialUserSceneResp resp = new TrialUserSceneResp();
        ArrayList<TrialSceneResp> listResp = new ArrayList<TrialSceneResp>();
        for (TrialUserSceneData data : userSceneList) {
            TrialSceneReq sceneReq = new TrialSceneReq();
            sceneReq.setSceneKey(data.getSceneKey());
            TrialSceneResp sceneResp = this.trialSceneService.listWithSteps(sceneReq);
            listResp.add(sceneResp);
        }
        resp.setScenes(listResp);
        return resp;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int deleteBindSceneBySceneId(Long sceneId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        return this.trialUserSceneMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int deleteWithUser(String userId, Long sceneId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        queryWrapper.eq((Object)"user_id", (Object)userId);
        return this.trialUserSceneMapper.delete((Wrapper)queryWrapper);
    }
}

