/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.usertrack.analyzer;

import com.digiwin.athena.base.application.service.usertrack.analyzer.AbstractReportDataAnalyzer;
import com.digiwin.athena.base.infrastructure.meta.po.usertrack.mongo.UserTrackExtendDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UserTrackAnalyzer
extends AbstractReportDataAnalyzer {
    public static final String USER_TRACK_ANALYSIS = "userTrack_analyzer";

    @Override
    public String getSourceType() {
        return USER_TRACK_ANALYSIS;
    }

    @Override
    public void analysis(List<UserTrackExtendDTO> userTrackDataList) {
        HashMap<String, List> tenantTrackMap = new HashMap<String, List>();
        userTrackDataList.stream().filter(userTrack -> StringUtils.isNotBlank((CharSequence)userTrack.getTenantId())).forEach(userTrack -> {
            List tenantTrackList = tenantTrackMap.computeIfAbsent(userTrack.getTenantId(), tenantId -> new ArrayList());
            tenantTrackList.add(userTrack);
        });
        if (MapUtils.isEmpty(tenantTrackMap)) {
            return;
        }
        tenantTrackMap.forEach((tenantId, tenantTrackList) -> this.userTrackMapper.safeSaveTrackData(tenantId, tenantTrackList));
    }

    @Override
    public void clear() {
    }
}

