package com.digiwin.athena.atdm.importstatistics.dto;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;

/**
 * 基础资料下载接口入参
 */
@Data
public class DownloadBaseDataParamDTO {
    /**
     * 分页查询参数
     */
    private PageInfo pageInfo;

    /**
     * "sort_info" : [{
     * "sort_field" : "requisitions_no",
     * "sort_type" : "asc",
     * "sort_seq" : "1"
     * },{
     * "sort_field" : "requisitions_seq",
     * "sort_type" : "desc",
     * "sort_seq" : "2"
     * }]
     */
    private List<Map> sortInfo;
    /**
     * 通用过滤
     * "search_info": [
     * {
     * "search_field": "name",
     * "search_operator": "equal",
     * "search_value": "印表機"
     * },
     * {
     * "search_field": "status",
     * "search_operator": "equal",
     * "search_value": "生效"
     * }
     * ]
     */
    private List<Map> searchInfo;

    /**
     * 业务参数数据
     */
    private ActionInfoDTO actionInfo;

    /**
     * 应用 code
     */
    private String application;

    /**
     * 类型：0:业务数据录入; 1:历史项目任务；2:任务；3:项目
     */
    private String type;

    /**
     * 跳转所需要的参数
     */
    private PositionParam positionParams;


    @Getter
    @Setter
    public static class PositionParam {

        private String code;

        private String category;

        private String appCode;

        private String resCode;

        private String ifCustom;

        private String backlogId;
    }
}

