package com.digiwin.athena.atdm.importstatistics.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 导出记录表（export_batch_record 是 export_statistics 子表）
 * 历史项目/任务列表明细导出
 *
 * @author xuhx
 * @date 2025/5/21
 */
@Data
public class ExportBatchRecord {

    private Long id;

    /**
     * 导出记录id
     * export_statistics的masterId
     */
    private String masterId;

    /**
     * 批次序列
     */
    private Integer batchSeq;

    /**
     * 类型。表示本行数据的业务范畴。目前1-历史任务详情数据导出；2-历史项目详情数据导出；
     */
    private String type;

    /**
     * 批次任务关联的业务id或其他内容。例如可能是历史任务的id、历史项目的id，或其他id
     */
    private String relate;

    /**
     * 导出参数，json格式。根据需要定义
     */
    private String exportParams;

    /**
     * 处理状态。1-成功；0-失败；2-导出中
     */
    private Integer state;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * 项目或任务所属KM定义的code
     */
    private String code;

    /**
     * 项目或任务所属KM定义的name
     */
    private String name;

    /**
     * 返回给前端用的，处理了语言别
     */
    private String activityName;

    /**
     * 当前项目或任务在zip包中的文件名。仅查看，不提供单个文件下载。
     * 便于用户区分这一批导出了哪些任务或项目
     */
    private String fileName;

    /**
     * 文档id、地址
     */
    private String fileUrl;

    /**
     * 条数
     */
    private Integer totalSize;

    /**
     * 访问权限
     */
    private String access;

    /**
     *  消耗时间
     */
    private String consumeTime;

    private String proxyToken;

    private String tenantId;

    /**
     * 文件状态:1-有效，0-已失效；
     */
    private Integer fileState;

    /**
     * 归档类型。hot-热库数据；archive-已归档数据；all-不确定；
     */
    private String archiveRouteKey;

    /**
     * 备注
     */
    private String remark;
}
