package com.digiwin.athena.atdm.importstatistics.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @ClassName ExportStatisticsDTO
 * @Description TODO
 * @Author lisheng
 * @Date 2023/9/20 11:30
 * @Version 1.0
 **/
@Data
public class ExportStatisticsDTO {

    private Long id;

    /**
     * 导出记录id
     */
    private String masterId;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 用户json
     */
    private String userJson;

    /**
     * 用户token,用于异步请求
     */
    private String userToken;

    /**
     * 状态,1-成功，0-失败；2-导入中
     */
    private Integer state;

    /**
     * 对应数据源的actionId
     */
    private String actionId;

    /**
     * 导出文件名
     */
    String fileName;

    /**
     * 导出文档在文档系统的url,无需前缀
     */
    private String fileUrl;

    /**
     * 文件状态:1-有效，0-已失效；
     */
    private Integer fileState;

    /**
     * 失效时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date expireTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * 导入时语言别,决定后续处理的展示语言别
     */
    private String locale;

    /**
     * 导出时 文件类型  0:业务数据录入  1:历史项目任务
     */
    private String type;

    /**
     * 导出zip包加密密码
     */
    private String defence;

    /**
     * 导出笔数
     */
    private Integer totalSize;

    /**
     * 0:未重新导出 1:已重新导出
     */
    private String hasBeenReExported;

    /**
     * 导出参数
     */
    private String exportParams;

//    private String exportModel;

    private String positionParam;

    /**
     * 耗时
     */
    private String consumeTime;

    /**
     * 访问权限
     */
    private String access;

    /**
     * 本次查询总数
     */
    private Integer queryPageTotal;

    /**
     * 失败笔数
     */
    private Integer failedSize;

    /**
     * 导出批次记录
     * export_batch_record
     */
    private List<ExportBatchRecord> exportBatchRecords;

}
