package com.digiwin.athena.base.infrastructure.manager.eoc;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EmpAgentSaveReqDTO;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EmpInfoDTO;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EocEmpInfoDTO;
import net.sf.json.JSONArray;

import java.util.List;

/**
 * EocService Description
 *
 * @author majianfu
 * @date 2022/8/1
 * @since
 */
public interface BaseEocService {
    /**
     * 根据userId查询员工部门信息
     *
     * @param userIds
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<EmpInfoDTO> queryEmpDeptInfoByUserId(List<String> userIds, int pageNum, int pageSize);

    /**
     * 调用eoc接口保存代理人和代理时间
     *
     * @param proxyInfoSaveReq
     * @param user
     */
    void empAgentChange(EmpAgentSaveReqDTO proxyInfoSaveReq, AuthoredUser user);

    /**
     * 批量保存代理人信息
     *
     * @param needSendMsgToEocList
     * @param user
     */
    void batchEmpAgentChange(List<EmpAgentSaveReqDTO> needSendMsgToEocList, AuthoredUser user);

    /**
     * 调用eoc接口清除代理人信息
     *
     * @param userId
     * @param user
     */
    void empAgentClear(String userId, AuthoredUser user);

    /**
     * 根据token获取对应租户的所有部门及子部门
     *
     * @return
     */
    JSONArray queryCurrentTenantAllDepartment();

    /**
     * 根据部门Sid获取部门下的人员
     *
     * @param departmentSid
     * @return
     */
    List<EocEmpInfoDTO> queryMembersOfTheDepartment(String departmentSid);

}
