package com.digiwin.athena.base.infrastructure.manager.thememap;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.AuthorityConfigResp;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.BaseActivityDefineDTO;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.BaseItemDto;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.TmAppDTO;

import java.util.List;
import java.util.Map;

/**
 * ThemeMapService Description
 *
 * @author majianfu
 * @date 2021/8/28
 * @since
 */
public interface BaseThemeMapService {
    /**
     * 获取租户下的基础资料作业列表
     *
     * @return
     */
    List<BaseActivityDefineDTO> getTenantBasicDataActivities();

    /**
     * 根据patten获取作业定义基本信息列表（appCode，appName，code，name，pattern，category等）
     *
     * @param pattern
     * @return
     */
    List<BaseActivityDefineDTO> getTenantActivitiesByPattern(String pattern);

    /**
     * 获取租户下的报表作业列表
     *
     * @return
     */
    List<BaseActivityDefineDTO> getTenantReportActivities();

    /**
     * 获取活动的权限配置
     *
     * @param tmActivityIdList
     * @param locale
     * @return
     */
    List<AuthorityConfigResp> getActivityAuthorityConfig(List<String> tmActivityIdList, String locale);

    /**
     * 获取活动的权限配置
     *
     * @param tmTaskIdList
     * @param locale
     * @return
     */
    List<AuthorityConfigResp> getTaskAuthorityConfig(List<String> tmTaskIdList, String locale);

    /**
     * 迁移atmc中的基础资料录入、报表数据
     *
     * @Date：2022/5/26 17:01
     */
    List<BaseItemDto> getActivitiesByPattern(AuthoredUser user, Integer plat, String url, String pattern);

    /**
     * 获取项目列表
     * @param user
     * @return
     */
    List<Map<String,Object>> getActivitiesStartProject(AuthoredUser user);

    /**
     * 获取作业定义
     *
     * @param tmActivityId
     * @param pageCode
     * @param locale
     * @return
     */
    Map getActivityWithoutTaskId(String tmActivityId, String pageCode, String locale);

    /**
     *
     * @param codeList  任务code  项目code  基础资料code  报表code  发起项目code
     * @param type  项目/发起项目 project    任务/基础资料/报表  task
     * @return
     */
    List<TmAppDTO> getAppInfoByCodeAndType(String type, List<String> codeList);

    /**
     * 获取租户配置，分组
     */
    Map getGroupConfig();

    Map<String, Object> getQueryCondition(String pageCode, String conditionType);

}
