package com.digiwin.athena.base.infrastructure.mongo;

import com.digiwin.athena.base.infrastructure.meta.po.userdefined.mongo.UserDefineData;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;


@Repository
public class AgileReportUserDefineMongoMapper {

    @Resource
    private MongoTemplate userdefinedMongoTemplate;

    private String COLLECTION_NAME  = "user_defined_gridster";

    /**
     * 保存用户自定义布局属性
     * @param userDefineData
     */
    public void save(UserDefineData userDefineData) {
        Query query = new Query(Criteria.where("snapshotId").is(userDefineData.getSnapshotId()).and("tenantId").is(userDefineData.getTenantId())
                .and("userId").is(userDefineData.getUserId()));
        Boolean exists = this.userdefinedMongoTemplate.exists(query,COLLECTION_NAME);
        Update update = new Update();
        if (exists) {
            update.set("updateDate", LocalDateTime.now()); // 设置更新时间
            update.set("dashboard",userDefineData.getDashboard());
            this.userdefinedMongoTemplate.upsert(query,update,COLLECTION_NAME);
        }else {
            userDefineData.setCreateDate(LocalDateTime.now());  // 设置创建时间
            this.userdefinedMongoTemplate.insert(userDefineData,COLLECTION_NAME);//插入数据
        }
    }

    /**
     * 获取用户自定义布局属性
     * @param userId
     * @param snapshotId
     */
    public List<UserDefineData> getUserDefine(String snapshotId, String userId, String tenantId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("userId").is(userId)
                .and("snapshotId").is(snapshotId).and("tenantId").is(tenantId));
        return this.userdefinedMongoTemplate.find(query, UserDefineData.class,COLLECTION_NAME);

    }

    public boolean existUserDefineData(String userId, String tenantId, String snapshotId){
        Query query = new Query(Criteria.where("snapshotId").is(snapshotId).and("tenantId").is(tenantId)
                .and("userId").is(userId));
        Boolean existRecord = this.userdefinedMongoTemplate.exists(query,COLLECTION_NAME);
        return existRecord;
    }
}
