/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.manager.thememap;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.HttpUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.infrastructure.manager.thememap.BaseThemeMapService;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.AuthorityConfigResp;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.BaseActivityDefineDTO;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.BaseItemDto;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.TmAppDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class BaseThemeMapServiceImpl
implements BaseThemeMapService {
    private static final Logger log = LoggerFactory.getLogger(BaseThemeMapServiceImpl.class);
    private static final String GET_ACTIVITIES_BY_PATTERN_URL = "knowledgegraph/task/activitiesByPattern";
    private static final String BASIC_DATA_PATTERN = "DATA_ENTRY";
    public static final String REPORT_PATTERN = "STATEMENT";
    public static final String BASE_DATA_PATTERN = "DATA_ENTRY";
    public static final Integer BASE_DATA_PLAT = 0;
    public static final Integer REPORT_PLAT = 1;
    public static final String APP_EXPIRED_ERROR_CODE = "RELATED_APP_EXPIRED";
    @Resource
    private RestTemplate restTemplate;
    @Value(value="${themeMap.uri:}")
    private String themeMapUri;
    @Resource
    private MessageUtils messageUtils;

    @Override
    public List<BaseActivityDefineDTO> getTenantBasicDataActivities() {
        return this.getTenantActivitiesByPattern("DATA_ENTRY");
    }

    @Override
    public List<BaseActivityDefineDTO> getTenantActivitiesByPattern(String pattern) {
        String url = UriComponentsBuilder.fromUriString((String)(this.themeMapUri + GET_ACTIVITIES_BY_PATTERN_URL)).queryParam("pattern", new Object[]{pattern}).build().toString();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<BaseActivityDefineDTO>>>(){}, new Object[0]);
            List activityDefineList = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            if (CollectionUtils.isNotEmpty((Collection)activityDefineList)) {
                activityDefineList.stream().forEach(activityDefine -> activityDefine.setPattern(pattern));
                return activityDefineList;
            }
            return Collections.emptyList();
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)url, (Object)ex);
            throw ex;
        }
    }

    @Override
    public List<BaseActivityDefineDTO> getTenantReportActivities() {
        return this.getTenantActivitiesByPattern(REPORT_PATTERN);
    }

    @Override
    public List<AuthorityConfigResp> getActivityAuthorityConfig(List<String> tmActivityIdList, String locale) {
        String url = this.themeMapUri + "knowledgegraph/activity/AuthorityConfigs";
        HashMap<String, Object> reqBody = new HashMap<String, Object>();
        reqBody.put("activityIdList", tmActivityIdList);
        return this.getAuthorityConfig(url, reqBody, locale);
    }

    @Override
    public List<AuthorityConfigResp> getTaskAuthorityConfig(List<String> tmTaskIdList, String locale) {
        String url = this.themeMapUri + "knowledgegraph/task/AuthorityConfigs";
        HashMap<String, Object> reqBody = new HashMap<String, Object>();
        reqBody.put("taskIdList", tmTaskIdList);
        return this.getAuthorityConfig(url, reqBody, locale);
    }

    @Override
    public List<BaseItemDto> getActivitiesByPattern(AuthoredUser user, Integer plat, String url, String pattern) {
        String uri = this.themeMapUri + (StringUtils.isEmpty((Object)url) ? "/knowledgegraph/task/activitiesByPattern?pattern=" : url);
        String string = pattern = pattern == null ? "" : pattern;
        if (Objects.equals(plat, 0)) {
            pattern = "DATA_ENTRY";
        } else if (Objects.equals(plat, 1)) {
            pattern = StringUtils.hasLength((String)pattern) ? pattern : REPORT_PATTERN;
        }
        uri = uri + pattern;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("locale", LocaleContextHolder.getLocale().toString());
        headers.set("token", user.getToken());
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity respMap = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<BaseItemDto>>>(){}, param);
            return (List)((BaseResultDTO)respMap.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
    }

    @Override
    public List<Map<String, Object>> getActivitiesStartProject(AuthoredUser user) {
        String uri = this.themeMapUri + "/knowledgegraph/task/manualList";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("locale", LocaleContextHolder.getLocale().toString());
        headers.set("token", user.getToken());
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity respMap = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map<String, Object>>>>(){}, param);
            return (List)((BaseResultDTO)respMap.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
    }

    private List<AuthorityConfigResp> getAuthorityConfig(String url, Map<String, Object> reqBody, String locale) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", locale);
        headers.add("token", this.getToken());
        HttpEntity requestEntity = new HttpEntity(reqBody, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<AuthorityConfigResp>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(reqBody), (Object)ex);
            throw ex;
        }
    }

    private String getToken() {
        if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken();
        }
        return AppAuthContextHolder.getContext().getAuthoredUser().getToken();
    }

    @Override
    public Map getActivityWithoutTaskId(String tmActivityId, String pageCode, String locale) {
        String url = this.themeMapUri + "knowledgegraph/task/activityDefinition?" + "activityId=" + tmActivityId + "&pageCode=" + pageCode;
        return this.getTmActivityDef(pageCode, locale, url);
    }

    @Override
    public List<TmAppDTO> getAppInfoByCodeAndType(String type, List<String> codeList) {
        String url = this.themeMapUri + "knowledgegraph/task/applicationRelation";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("codes", codeList);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TmAppDTO>>>(){}, new Object[0]);
            log.info("[getAppInfoByCodeAndType]  type = {}, codes = {}, result = {}", new Object[]{type, JsonUtils.objectToString(codeList), JsonUtils.objectToString((Object)respEntity)});
        }
        catch (Exception e) {
            log.error("[getAppInfoByCodeAndType] execute km [knowledgegraph/task/applicationRelation] fail, error = {}", (Object)e.getMessage());
        }
        if (null != respEntity && null != respEntity.getBody()) {
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        return null;
    }

    @Override
    public Map getGroupConfig() {
        String url = this.themeMapUri + "knowledgegraph/task/cardConfig";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", this.getToken());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
        Map cardConfig = (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        if (null == cardConfig) {
            throw BusinessException.create((String)String.format(this.messageUtils.getMessage("exception.tm.null"), url));
        }
        return cardConfig;
    }

    private Map getTmActivityDef(String pageCode, String locale, String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", locale);
        headers.add("token", this.getToken());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
            Map tmActivity = (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
            if (null == tmActivity) {
                throw BusinessException.create((String)String.format(this.messageUtils.getMessage("exception.tm.null"), url));
            }
            return tmActivity;
        }
        catch (HttpServerErrorException ex) {
            if (HttpStatus.INTERNAL_SERVER_ERROR.value() == ex.getStatusCode().value()) {
                BaseResultDTO baseResultDTO = null;
                try {
                    baseResultDTO = (BaseResultDTO)JsonUtils.jsonToObject((String)ex.getResponseBodyAsString(), (TypeReference)new TypeReference<BaseResultDTO>(){});
                }
                catch (Exception exception) {
                    baseResultDTO = null;
                }
                if (null != baseResultDTO && this.isAppExpiredErrorResp(baseResultDTO.getStatus(), baseResultDTO.getErrorCode())) {
                    String errMsg = this.messageUtils.getMessageWithFormat("exception.app.expired", new Object[]{baseResultDTO.getErrorMessage()});
                    throw BusinessException.create((Integer)baseResultDTO.getStatus(), (String)"P.KM.600.11111", (Object)errMsg, (String)errMsg, (String)errMsg, null);
                }
                throw ex;
            }
            throw ex;
        }
    }

    private boolean isAppExpiredErrorResp(int statusCode, String errorCode) {
        return HttpStatus.INTERNAL_SERVER_ERROR.value() == statusCode && APP_EXPIRED_ERROR_CODE.equals(errorCode);
    }

    @Override
    public Map<String, Object> getQueryCondition(String pageCode, String conditionType) {
        String url = this.themeMapUri + "knowledgegraph/task/queryCondition";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", this.getToken());
        JSONObject jsonObject = new JSONObject();
        jsonObject.putIfAbsent((Object)"pageCode", (Object)pageCode);
        jsonObject.putIfAbsent((Object)"configType", (Object)conditionType);
        HashMap result = new HashMap();
        JSONObject body = new JSONObject();
        body.putIfAbsent((Object)"cardConditionQuery", (Object)jsonObject);
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, new Object[0]);
        return (Map)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

