package com.digiwin.athena.base.infrastructure.constant;

import com.digiwin.athena.appcore.exception.BusinessException;
import lombok.Getter;

public enum AudcErrorCodeEnum {
    /**
     * P.AUDC.400.xxxx  鉴权错误
     * P.AUDC.500.xxxx  业务错误
     */
    INVALID_REQUEST_PARAM("P.AUDC.500.0001"),
    // Permission check 00XX
    AUTH_PREFIX_CONFIG_ERROR("P.AUDC.400.0001"),
    // Common used 01XX
    COMMON_USED_CATEGORY_NOT_EXIST("P.AUDC.500.0101"),
    /**
     *  参数错误
     */
    COMMON_REQUEST_PARAM_ERROR("P.AUDC.500.0002"),
    /**
     * 值重复
     */
    COMMON_REQUEST_DATA_REPEAT_ERROR("P.AUDC.500.0003"),
    /**
     * 空字符串
     */
    EMPTY_STRING_ERROR("P.AUDC.500.0004"),



    // User track 02XX
    // Visit 03XX

    // FI 05xx
    FI_RECOMMEND("P.AUDC.500.0501"),
    /**
     * emc: P.AUDC.902.xxxx
     * iam: P.AUDC.903.xxxx
     * cac: P.AUDC.904.xxxx
     * eoc: P.AUDC.905.xxxx
     * dmc: P.AUDC.906.xxxx
     *
     */
    IAM_V2_USER_APPLICATION("P.AUDC.903.0001"),
    IAM_V2_PERMISSION_USERS_APPS_ALL("P.AUDC.903.0002"),
    IAM_V2_QUERY_USER("P.AUDC,903.0003"),
    EOC_V2_EMP_SIMPLE("P.AUDC.905.20001"),

    EMC_V1_MESSAGE_EMAIL("P.AUDC.902.21001"),
    EOC_V2_EMP_AGENT_CHANGE("P.AUDC.905.20002"),
    EOC_V2_EMP_AGENT_CLEAR("P.AUDC.905.20003"),
    ATMC_V1_MESSAGE_AGENT_CHANGE("P.AUDC.907.0001"),

    ATMC_V1_MESSAGE_AGENT_CLEAR("P.AUDC.907.0002"),

    //业务类型
    // Cofw
    COFW_SAVE_FAILED("P.AUDC.600.0001"),

    //编辑态异常
    PAGE_MODEL_UPDATE_EDIT("P.AUDC.700.0001"),
    PAGE_MODEL_UPDATE_EDIT_NO_CURRENT("P.AUDC.700.0004"),
    PAGE_MODEL_DELETE_NO_RECORD("P.AUDC.700.0002"),
    PAGE_MODEL_DELETE_NO_CURRENT("P.AUDC.700.0003"),
    PAGE_MODEL_DELETE_LOCK("P.AUDC.700.0006"),
    PAGE_MODEL_GET_EDIT("P.AUDC.700.0005");



    /**
     * 错误码
     */
    @Getter
    private String errCode;

    AudcErrorCodeEnum(String errCode) {
        this.errCode = errCode;
    }

    /**
     * ErrorCodeEnum转BusinessException
     *
     * @param errorMsg 错误信息
     * @return BusinessException实例
     */
    public BusinessException getBusinessException(String errorMsg) {
        return BusinessException.create(this.getErrCode(), errorMsg);
    }

    /**
     * ErrorCodeEnum转BusinessException
     *
     * @param errorMsg 错误信息
     * @param cause    原始异常
     * @return BusinessException实例
     */
    public BusinessException getBusinessException(String errorMsg, Throwable cause) {
        return BusinessException.create(this.getErrCode(), errorMsg, cause);
    }
}
