package com.digiwin.athena.base.infrastructure.meta.po.guide;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2022/05/18 16:15:32
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "user_guide_log")
public class UserGuideLog extends BaseEntity<UserGuideLog> implements Serializable {

    /**
     * 主键ID
     */
    @TableId()
    private Long id;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 所属应用：（应用code或者Athena)
     */
    private String appCode;

    /**
     * 按照全部菜单分级调整，基础资料:baseEntrty 报表：report  发起项目：startProject
     */
    private String modularCode;
    /**
     * 终端类型  web：网页端  pc：端等等，目前不做控制，默认web
     */
    private String terminalType;

    private String code;

    private String subKey;

}
