package com.digiwin.athena.atdm.importstatistics.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.importstatistics.ServiceException;
import com.digiwin.loadbalance.util.HttpRouteUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;

@Component
@SuppressWarnings({"findsecbugs:WEAK_TRUST_MANAGER", "findsecbugs:HTTP_PARAMETER_POLLUTION"})
public class Utils {
	private static Logger logger = LoggerFactory.getLogger(Utils.class);
	
	static HttpClient httpclient = null;
	
	static RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000)
			.setConnectionRequestTimeout(60000).setSocketTimeout(60000).setMaxRedirects(50).build();
	/**
	 * 注入区中心化的HttpRoutePlanner
	 */
	@Autowired(required = false)
	@Qualifier(HttpRouteUtils.ATTEMPT_HTTPCLIENT_ROUTE_PLAN)
	HttpRoutePlanner initHttpRoutePlanner;

	static HttpRoutePlanner httpRoutePlanner;

	@PostConstruct
	public void init() {
		httpRoutePlanner = initHttpRoutePlanner;
	}
	public static HttpClient getHttpClient() {
		if (null == httpclient) {
			SSLContext sslContext = null;
			try {
				sslContext = SSLContext.getInstance("TLS");
				X509TrustManager tm = new X509TrustManager() {
					@Override
					public void checkClientTrusted(X509Certificate[] chain, String authType) {
						if (false) {
							throw new ServiceException();
						}
					}

					@Override
					public void checkServerTrusted(X509Certificate[] chain, String authType) {
						if (false) {
							throw new ServiceException();
						}
					}

					@Override
					public X509Certificate[] getAcceptedIssuers() {
						return null;
					}
				};

				sslContext.init(null, new TrustManager[] { tm }, null);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				logger.error(e.toString());
			}

			httpclient = HttpClients.custom().setMaxConnPerRoute(1000).setMaxConnTotal(1000).setSSLContext(sslContext)
				.setRoutePlanner(httpRoutePlanner)
					// .disableAutomaticRetries()
					.build();
		}
		return httpclient;
	}

	private static Header[] toHeader(Map<String,String> headers){


		if(null!=headers){
			ArrayList<Header> hs = new ArrayList<>();
			headers.forEach((k,v)->{
				hs.add(new BasicHeader(k,v));
			});
			return hs.toArray(new Header[]{});
		}

		return null;
	}

	public static String postJson(String url, Map<String,String> headers,Map<String,Object> params) {
		String result = null;

		HttpPost httppost = new HttpPost(url);
		httppost.setConfig(requestConfig);
		httppost.setHeaders(toHeader(headers));
		String jsonbody = JSON.toJSONString(params, SerializerFeature.WriteMapNullValue);
		StringEntity myEntity = new StringEntity(jsonbody, ContentType.APPLICATION_JSON);
		httppost.setEntity(myEntity);
		HttpResponse response = null;
		if (logger.isInfoEnabled()) {
			logger.info("post to:" + url + ",and request body=" + jsonbody);
		}
		try {
			response = getHttpClient().execute(httppost);
			HttpEntity entity = response.getEntity();
			result = EntityUtils.toString(entity, "UTF-8");
		} catch (IOException e) {
			logger.error(e.getMessage(), e);
		} finally {
			HttpClientUtils.closeQuietly(response);
		}
		if (logger.isInfoEnabled()) {
			logger.info("response from :" + url + ",response body=" + result);
		}

		return result;
	}

	public static <T> T postJson(String url,Map<String,String> headers, Map<String,Object> params, Class<T> c) {
		T result = null;
		try {
			result = JsonUtils.jsonToObject(postJson(url, headers, params), c);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}

		return result;
	}

	public static String deleteJson(String url, Map<String,String> headers,Map<String,Object> params) {
		String result = null;
		RestTemplate restTemplate = new RestTemplate();
		HttpHeaders head =new HttpHeaders();
		if (!CollectionUtils.isEmpty(headers)) {
			for (Map.Entry<String, String> item : headers.entrySet()) {
				head.add(item.getKey(), item.getValue());
			}
		}
		if (logger.isInfoEnabled()) {
			logger.info("delete to:" + url + ",and request body=" + params);
		}
		org.springframework.http.HttpEntity<Map> request = new org.springframework.http.HttpEntity<>(params, head);
		ResponseEntity re = restTemplate.exchange(url, HttpMethod.DELETE, request, Object.class);
		if (re != null) {
			result = JsonUtils.objectToString(re.getBody());
		}
		return result;
	}

	public static <T> T deleteJson(String url,Map<String,String> headers, Map<String,Object> params, Class<T> c) {
		T result = null;
		try {
			result = JsonUtils.jsonToObject(deleteJson(url, headers, params), c);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}

		return result;
	}

	public static HttpResponse get0(String url, Header[] headers, Map<String, Object> params) {

		if (null != params && !params.isEmpty()) {
			StringBuilder sb = new StringBuilder();
			sb.append("?");
			params.forEach((k, v) -> {
				try {
					String sv = v.toString();
					sb.append(k).append("=").append(URLEncoder.encode(sv, "UTF-8")).append("&");
				} catch (UnsupportedEncodingException e) {
					logger.error(e.getMessage(), e);
				}
			});
			url = url + sb.substring(0, sb.length() - 1).toString();
		}
		HttpGet get = new HttpGet(url);
		get.setHeaders(headers);
		HttpResponse response = null;
		if (logger.isInfoEnabled()) {
			logger.info("get url=" + url + ",headers=" + JsonUtils.objectToString(headers) + ",params=" + params);
		}
		try {
			response = getHttpClient().execute(get);
			return response;
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
		return null;
	}

	public static String get(String url, Map<String,String> headers, Map<String, Object> params) {
		String result = null;

		HttpResponse response = get0(url,toHeader(headers),params);
		if (null == response) {
			return result;
		}
		HttpEntity entity = response.getEntity();
		try {
			result = EntityUtils.toString(entity, "UTF-8");
			if (logger.isInfoEnabled()) {
				logger.info("get result=" + result);
			}
		} catch (IOException e) {
			logger.error("IOException", e);
		}
		HttpClientUtils.closeQuietly(response);

		return result;
	}

	public static <T> T get(String url,Map<String,String> headers, Map<String, Object> params, Class<T> c) {
		T result = null;
		try {
			result = JsonUtils.jsonToObject(get(url, headers, params), c);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}

		return result;
	}
}
