package com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.TaskCardListConfigData;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

@Mapper
public interface TaskCardListConfigMapper extends BaseMapper<TaskCardListConfigData> {

    @Select("select * from task_card_list_config where user_id=#{userId} and tenant_id=#{tenantId} and group_type=#{groupType} and page_code = #{pageCode} and BINARY group_id=#{groupId} ")
    TaskCardListConfigData getOne(@Param(value = "userId")String userId,
                                  @Param(value = "tenantId") String tenantId,
                                  @Param(value = "groupId") String groupId,
                                  @Param(value = "groupType") Integer groupType,
                                  @Param(value = "pageCode") String pageCode);

    @Update("update task_card_list_config set config =#{config} where user_id=#{userId} and tenant_id=#{tenantId} and group_type=#{groupType} and page_code = #{pageCode} and BINARY group_id =#{groupId}")
    Integer updateConfig(@Param(value = "userId") String userId,
                         @Param(value = "tenantId") String tenantId,
                         @Param(value = "groupId") String groupId,
                         @Param(value = "groupType") Integer groupType,
                         @Param(value = "config") String config,
                         @Param(value = "pageCode") String pageCode);
}
