/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.manager.aim;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.base.infrastructure.config.EnvProperties;
import com.digiwin.athena.base.infrastructure.manager.aim.BaseAimService;
import com.digiwin.athena.base.infrastructure.manager.aim.model.MessageBatchUserDTO;
import com.digiwin.athena.base.infrastructure.manager.aim.model.MessageDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class BaseAimServiceImpl
implements BaseAimService {
    private static final Logger log = LoggerFactory.getLogger(BaseAimServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    public static final String SEND_MESSAGE_TO_CLIENT = "/api/aim/v2/send/message/to/client";

    @Override
    public void sendMessageToClient(String token, String tenantId, List<String> userIdList, MessageDO message) {
        log.info("sendMessageToClient message:{}", (Object)message);
        LogDto logDto = new LogDto("\u8bf7\u6c42aim\u53d1\u9001\u65b0\u6d88\u606f\u5f00\u59cb\uff0cuserIds\uff1a" + userIdList, tenantId + userIdList.toString());
        log.info(logDto.toString());
        MessageBatchUserDTO messageBatchUserDTO = new MessageBatchUserDTO();
        messageBatchUserDTO.setMessage(message);
        messageBatchUserDTO.setUserIdList(userIdList);
        messageBatchUserDTO.setTenantId(tenantId);
        String url = this.envProperties.getAimUri() + SEND_MESSAGE_TO_CLIENT;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HttpEntity httpEntity = new HttpEntity((Object)messageBatchUserDTO, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
        log.info("sendMessageToClient respEntity:{}", (Object)((BaseResultDTO)respEntity.getBody()).getStatusDescription());
        ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }
}

