/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.importstatistics.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class MyCollectionUtils {
    public static final String DEFAULT_DELIMITER = "&&";

    public static <T, R> Map<String, List<T>> groupingBy(List<T> list, Function<T, R>[] functions) {
        return list.stream().collect(Collectors.groupingBy(t -> MyCollectionUtils.groupingBy(t, functions)));
    }

    public static String getJoinedKey(List<String> keys) {
        StringBuilder sb = new StringBuilder();
        for (String s : keys) {
            if (s == null || "".equals(s)) continue;
            sb.append(DEFAULT_DELIMITER).append(s);
        }
        return sb.toString();
    }

    public static <T, R> String groupingBy(T t, Function<T, R>[] functions) {
        if (functions == null || functions.length == 0) {
            throw new NullPointerException("functions\u6570\u7ec4\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (functions.length == 1) {
            return functions[0].apply(t).toString();
        }
        return Arrays.stream(functions).map(fun -> String.valueOf(fun.apply(t))).reduce((str1, str2) -> str1 + DEFAULT_DELIMITER + str2).orElse("");
    }

    public static Function<Map, Object>[] formMapGroupFunctions(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            throw new NullPointerException("keys\u6570\u7ec4\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        Function[] functionArray = new Function[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            Function<Map, Object> get;
            int finalI = i;
            functionArray[i] = get = p -> p.get(keys.get(finalI));
        }
        return functionArray;
    }
}

