package com.digiwin.athena.base.infrastructure.constant;

import com.digiwin.athena.appcore.exception.BusinessException;
import lombok.Getter;

/**
 * 错误码定义类
 *
 * @author majianfu
 * @date 2020/11/04
 * @since [迭代10]
 */
public enum AamErrorCodeEnum {
    // OK
    OK("200", "OK"),

    // 获取Token信息失败
    UNAUTHORIZED("404", "token异常，请重新登录"),

    INTERNAL_SERVER_ERROR("500", "Internal server error"),

    //业务报错
    UPLOAD_ATTANCHMENT_ERROR("P.AAM.600.0001","上传附件错误"),

    SHARE_ATTANCHMENT_ERROR("P.AAM.600.0002","分享附件错误");
    /**
     * 错误码
     */
    @Getter
    private String errCode;

    /**
     * 错误描述
     */
    @Getter
    private String errMsg;

    AamErrorCodeEnum(String errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    /**
     * ErrorCodeEnum转BusinessException
     *
     * @return BusinessException实例
     */
    public BusinessException getBusinessException() {
        return BusinessException.create(Integer.parseInt(this.getErrCode()), this.getErrMsg());
    }

    /**
     * ErrorCodeEnum转BusinessException
     *
     * @return BusinessException实例
     */
    public BusinessException getBusinessException(String errMsg) {
        return BusinessException.create(Integer.parseInt(this.getErrCode()), errMsg);
    }
}
