/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.config;

import com.digiwin.athena.appcore.AppCoreProperties;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EnvProperties {
    private static final Logger logger = LoggerFactory.getLogger(EnvProperties.class);
    @Autowired
    private AppCoreProperties appCoreProperties;
    @Value(value="${spring.profiles.active:paas}")
    private String active;
    @Value(value="${server.port}")
    private String port;
    @Value(value="${abt.uri:}")
    private String abtUri;
    @Value(value="${athena.auth.uri:}")
    private String iamUri;
    @Value(value="${themeMap.uri:}")
    private String themeMapUri;
    @Value(value="${atmc.uri:}")
    private String atmcUri;
    @Value(value="${eoc.uri:}")
    private String eocUri;
    @Value(value="${emc.uri:}")
    private String emcUri;
    @Value(value="${aim.uri:}")
    private String aimUri;
    @Value(value="${iam.cacUri:}")
    private String iamCacUri;
    @Value(value="${tdd.uri:}")
    private String tddUri;
    private String host;
    private String ipAddress;
    private long freeMemory;
    private long totalMemory;
    private long maxMemory;
    private String osName;
    private long pid;
    private LocalDateTime startTime;
    private String classPath;
    private String projectPath;
    private long runtime;
    private int threadCount;

    static long byteToM(long bytes) {
        long kb = bytes / 1024L / 1024L;
        return kb;
    }

    static long tryGetPid() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            String pid = name.split("@")[0];
            return Long.parseLong(pid);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public void refresh() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        this.setFreeMemory(EnvProperties.byteToM(freeMemory));
        long totalMemory = runtime.totalMemory();
        this.setTotalMemory(EnvProperties.byteToM(totalMemory));
        long maxMemory = runtime.maxMemory();
        this.setMaxMemory(EnvProperties.byteToM(maxMemory));
        this.setOsName(System.getProperty("os.name"));
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String hostName = localHost.getHostName();
            this.setHost(hostName);
            if (this.ipAddress == null) {
                this.ipAddress = localHost.getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            logger.error("refresh exception", (Throwable)e);
            this.setHost("\u672a\u77e5");
        }
        this.setIpAddress(this.ipAddress);
        long startTime = runtimeMXBean.getStartTime();
        LocalDateTime startDate = Instant.ofEpochMilli(startTime).atZone(ZoneOffset.ofHours(8)).toLocalDateTime();
        this.setStartTime(startDate);
        this.setRuntime(runtimeMXBean.getUptime());
        this.setThreadCount(ManagementFactory.getThreadMXBean().getThreadCount());
        this.setPid(EnvProperties.tryGetPid());
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public long getPid() {
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public long getRuntime() {
        return this.runtime;
    }

    public void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    @Generated
    public AppCoreProperties getAppCoreProperties() {
        return this.appCoreProperties;
    }

    @Generated
    public String getAbtUri() {
        return this.abtUri;
    }

    @Generated
    public String getIamUri() {
        return this.iamUri;
    }

    @Generated
    public String getThemeMapUri() {
        return this.themeMapUri;
    }

    @Generated
    public String getAtmcUri() {
        return this.atmcUri;
    }

    @Generated
    public String getEocUri() {
        return this.eocUri;
    }

    @Generated
    public String getEmcUri() {
        return this.emcUri;
    }

    @Generated
    public String getAimUri() {
        return this.aimUri;
    }

    @Generated
    public String getIamCacUri() {
        return this.iamCacUri;
    }

    @Generated
    public String getTddUri() {
        return this.tddUri;
    }

    @Generated
    public void setAppCoreProperties(AppCoreProperties appCoreProperties) {
        this.appCoreProperties = appCoreProperties;
    }

    @Generated
    public void setAbtUri(String abtUri) {
        this.abtUri = abtUri;
    }

    @Generated
    public void setIamUri(String iamUri) {
        this.iamUri = iamUri;
    }

    @Generated
    public void setThemeMapUri(String themeMapUri) {
        this.themeMapUri = themeMapUri;
    }

    @Generated
    public void setAtmcUri(String atmcUri) {
        this.atmcUri = atmcUri;
    }

    @Generated
    public void setEocUri(String eocUri) {
        this.eocUri = eocUri;
    }

    @Generated
    public void setEmcUri(String emcUri) {
        this.emcUri = emcUri;
    }

    @Generated
    public void setAimUri(String aimUri) {
        this.aimUri = aimUri;
    }

    @Generated
    public void setIamCacUri(String iamCacUri) {
        this.iamCacUri = iamCacUri;
    }

    @Generated
    public void setTddUri(String tddUri) {
        this.tddUri = tddUri;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnvProperties)) {
            return false;
        }
        EnvProperties other = (EnvProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFreeMemory() != other.getFreeMemory()) {
            return false;
        }
        if (this.getTotalMemory() != other.getTotalMemory()) {
            return false;
        }
        if (this.getMaxMemory() != other.getMaxMemory()) {
            return false;
        }
        if (this.getPid() != other.getPid()) {
            return false;
        }
        if (this.getRuntime() != other.getRuntime()) {
            return false;
        }
        if (this.getThreadCount() != other.getThreadCount()) {
            return false;
        }
        AppCoreProperties this$appCoreProperties = this.getAppCoreProperties();
        AppCoreProperties other$appCoreProperties = other.getAppCoreProperties();
        if (this$appCoreProperties == null ? other$appCoreProperties != null : !this$appCoreProperties.equals(other$appCoreProperties)) {
            return false;
        }
        String this$active = this.getActive();
        String other$active = other.getActive();
        if (this$active == null ? other$active != null : !this$active.equals(other$active)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$abtUri = this.getAbtUri();
        String other$abtUri = other.getAbtUri();
        if (this$abtUri == null ? other$abtUri != null : !this$abtUri.equals(other$abtUri)) {
            return false;
        }
        String this$iamUri = this.getIamUri();
        String other$iamUri = other.getIamUri();
        if (this$iamUri == null ? other$iamUri != null : !this$iamUri.equals(other$iamUri)) {
            return false;
        }
        String this$themeMapUri = this.getThemeMapUri();
        String other$themeMapUri = other.getThemeMapUri();
        if (this$themeMapUri == null ? other$themeMapUri != null : !this$themeMapUri.equals(other$themeMapUri)) {
            return false;
        }
        String this$atmcUri = this.getAtmcUri();
        String other$atmcUri = other.getAtmcUri();
        if (this$atmcUri == null ? other$atmcUri != null : !this$atmcUri.equals(other$atmcUri)) {
            return false;
        }
        String this$eocUri = this.getEocUri();
        String other$eocUri = other.getEocUri();
        if (this$eocUri == null ? other$eocUri != null : !this$eocUri.equals(other$eocUri)) {
            return false;
        }
        String this$emcUri = this.getEmcUri();
        String other$emcUri = other.getEmcUri();
        if (this$emcUri == null ? other$emcUri != null : !this$emcUri.equals(other$emcUri)) {
            return false;
        }
        String this$aimUri = this.getAimUri();
        String other$aimUri = other.getAimUri();
        if (this$aimUri == null ? other$aimUri != null : !this$aimUri.equals(other$aimUri)) {
            return false;
        }
        String this$iamCacUri = this.getIamCacUri();
        String other$iamCacUri = other.getIamCacUri();
        if (this$iamCacUri == null ? other$iamCacUri != null : !this$iamCacUri.equals(other$iamCacUri)) {
            return false;
        }
        String this$tddUri = this.getTddUri();
        String other$tddUri = other.getTddUri();
        if (this$tddUri == null ? other$tddUri != null : !this$tddUri.equals(other$tddUri)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$osName = this.getOsName();
        String other$osName = other.getOsName();
        if (this$osName == null ? other$osName != null : !this$osName.equals(other$osName)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        String this$classPath = this.getClassPath();
        String other$classPath = other.getClassPath();
        if (this$classPath == null ? other$classPath != null : !this$classPath.equals(other$classPath)) {
            return false;
        }
        String this$projectPath = this.getProjectPath();
        String other$projectPath = other.getProjectPath();
        return !(this$projectPath == null ? other$projectPath != null : !this$projectPath.equals(other$projectPath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EnvProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $freeMemory = this.getFreeMemory();
        result = result * 59 + (int)($freeMemory >>> 32 ^ $freeMemory);
        long $totalMemory = this.getTotalMemory();
        result = result * 59 + (int)($totalMemory >>> 32 ^ $totalMemory);
        long $maxMemory = this.getMaxMemory();
        result = result * 59 + (int)($maxMemory >>> 32 ^ $maxMemory);
        long $pid = this.getPid();
        result = result * 59 + (int)($pid >>> 32 ^ $pid);
        long $runtime = this.getRuntime();
        result = result * 59 + (int)($runtime >>> 32 ^ $runtime);
        result = result * 59 + this.getThreadCount();
        AppCoreProperties $appCoreProperties = this.getAppCoreProperties();
        result = result * 59 + ($appCoreProperties == null ? 43 : $appCoreProperties.hashCode());
        String $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : $active.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $abtUri = this.getAbtUri();
        result = result * 59 + ($abtUri == null ? 43 : $abtUri.hashCode());
        String $iamUri = this.getIamUri();
        result = result * 59 + ($iamUri == null ? 43 : $iamUri.hashCode());
        String $themeMapUri = this.getThemeMapUri();
        result = result * 59 + ($themeMapUri == null ? 43 : $themeMapUri.hashCode());
        String $atmcUri = this.getAtmcUri();
        result = result * 59 + ($atmcUri == null ? 43 : $atmcUri.hashCode());
        String $eocUri = this.getEocUri();
        result = result * 59 + ($eocUri == null ? 43 : $eocUri.hashCode());
        String $emcUri = this.getEmcUri();
        result = result * 59 + ($emcUri == null ? 43 : $emcUri.hashCode());
        String $aimUri = this.getAimUri();
        result = result * 59 + ($aimUri == null ? 43 : $aimUri.hashCode());
        String $iamCacUri = this.getIamCacUri();
        result = result * 59 + ($iamCacUri == null ? 43 : $iamCacUri.hashCode());
        String $tddUri = this.getTddUri();
        result = result * 59 + ($tddUri == null ? 43 : $tddUri.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $osName = this.getOsName();
        result = result * 59 + ($osName == null ? 43 : $osName.hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        String $classPath = this.getClassPath();
        result = result * 59 + ($classPath == null ? 43 : $classPath.hashCode());
        String $projectPath = this.getProjectPath();
        result = result * 59 + ($projectPath == null ? 43 : $projectPath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EnvProperties(appCoreProperties=" + this.getAppCoreProperties() + ", active=" + this.getActive() + ", port=" + this.getPort() + ", abtUri=" + this.getAbtUri() + ", iamUri=" + this.getIamUri() + ", themeMapUri=" + this.getThemeMapUri() + ", atmcUri=" + this.getAtmcUri() + ", eocUri=" + this.getEocUri() + ", emcUri=" + this.getEmcUri() + ", aimUri=" + this.getAimUri() + ", iamCacUri=" + this.getIamCacUri() + ", tddUri=" + this.getTddUri() + ", host=" + this.getHost() + ", ipAddress=" + this.getIpAddress() + ", freeMemory=" + this.getFreeMemory() + ", totalMemory=" + this.getTotalMemory() + ", maxMemory=" + this.getMaxMemory() + ", osName=" + this.getOsName() + ", pid=" + this.getPid() + ", startTime=" + this.getStartTime() + ", classPath=" + this.getClassPath() + ", projectPath=" + this.getProjectPath() + ", runtime=" + this.getRuntime() + ", threadCount=" + this.getThreadCount() + ")";
    }
}

