package com.digiwin.athena.atdm.importstatistics.kg;


import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.application.Application;
import com.digiwin.athena.atdm.importstatistics.common.api.DapResponse;
import com.digiwin.athena.atdm.importstatistics.kg.dto.ApplicationRelationReqByTypeAndCodesDTO;
import com.digiwin.athena.atdm.importstatistics.kg.dto.ApplicationRelationRespDTO;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-04-29 13:43
 **/
@Slf4j
@Service
public class DataEntryKgService {

    @Value("${themeMap.uri}")
    private String knowledgeGraphUrl;

    @Value("${themeMap.dataMapUri}")
    private String datamapUrl;

    private final String QUERY_DIGITALSTAFF = "/restful/service/knowledgegraph/app/queryDigitalStaffByCode";

    private final String GET_ENHANCE_BYAPPCODE = "/restful/service/knowledgegraph/app/enhanceByAppCode";

    private String kghost = null;

    public DapResponse getApplicationByNameAndTags(String applicationName, List<String> tags) {
        String url = datamapUrl + "/restful/standard/datamap/app/byNameAndTags";

        Map<String, Object> params = new HashMap<>();
        if (applicationName != null && !applicationName.isEmpty()) {
            params.put("applicationName", applicationName);
        } else {
            params.put("applicationName", "");
        }

        if (tags != null && !tags.isEmpty()) {
            params.put("tags", tags);
        } else {
            params.put("tags", new ArrayList<String>() {
            });
        }

        return DwSpringHttpUtil.post(url, params, new ParameterizedTypeReference<DapResponse<List<Application>>>() {
        });
    }

    public DapResponse<Map<String, List>> getDigitalStaff(Set<String> codeList, Set<String> enhanceCodeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0088.getErrCode(), MessageUtil.getMessage("delivery.codeListEmpty"));
        }

        Map<String, Object> params = new HashMap<>();
        params.put("codeList", codeList);
        params.put("enhanceCodeList", enhanceCodeList);

        String url = knowledgeGraphUrl + "/restful/service/knowledgegraph/app/queryDigitalStaffByCode";

        return DwSpringHttpUtil.post(knowledgeGraphUrl + QUERY_DIGITALSTAFF, params, new ParameterizedTypeReference<DapResponse<Map<String, List>>>() {
        });
    }

    public DapResponse<List<Application>> getEnhancebyAppCode(String code) {
        if (StringUtils.isEmpty(code)) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0089.getErrCode(), MessageUtil.getMessage("delivery.delivery.codeEmpty"));
        }

        Map<String, Object> params = new HashMap<>();
        params.put("code", code);

        String url = knowledgeGraphUrl + "/restful/service/knowledgegraph/app/enhanceByAppCode?code={code}";

        return DwSpringHttpUtil.get(url, new ParameterizedTypeReference<DapResponse<List<Application>>>() {
        }, params);
    }

    public DapResponse<List<ApplicationRelationRespDTO>> postApplicationRelationsByCodesAndType(List<String> code, String type) {
        Map<String, Object> params = new HashMap<>();
        ApplicationRelationReqByTypeAndCodesDTO applicationRelationQueryDTO = new ApplicationRelationReqByTypeAndCodesDTO();
        applicationRelationQueryDTO.setCodes(code);
        applicationRelationQueryDTO.setType(type);
        params.put("applicationRelationQueryDTO", applicationRelationQueryDTO);

        String url = datamapUrl + "/restful/standard/datamap/app/applicationRelationsByCodesAndType";
        return DwSpringHttpUtil.post(url, params, new ParameterizedTypeReference<DapResponse<List<ApplicationRelationRespDTO>>>() {
        });
    }

    public DapResponse<ApplicationRelationRespDTO> getApplicationByTypeAndCode(String type, String code) {
        Map<String, Object> params = new HashMap<>();
        params.put("type", type);
        params.put("code", code);

        String url = datamapUrl + "/restful/standard/datamap/app/applicationByTypeAndCode?type={type}&code={code}";
        return DwSpringHttpUtil.get(url, new ParameterizedTypeReference<DapResponse<ApplicationRelationRespDTO>>() {
        }, params);
    }

}
