/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.importstatistics.kg;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.application.Application;
import com.digiwin.athena.atdm.importstatistics.common.api.DapResponse;
import com.digiwin.athena.atdm.importstatistics.kg.dto.ApplicationRelationReqByTypeAndCodesDTO;
import com.digiwin.athena.atdm.importstatistics.kg.dto.ApplicationRelationRespDTO;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

@Service
public class DataEntryKgService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataEntryKgService.class);
    @Value(value="${themeMap.uri}")
    private String knowledgeGraphUrl;
    @Value(value="${themeMap.dataMapUri}")
    private String datamapUrl;
    private final String QUERY_DIGITALSTAFF = "/restful/service/knowledgegraph/app/queryDigitalStaffByCode";
    private final String GET_ENHANCE_BYAPPCODE = "/restful/service/knowledgegraph/app/enhanceByAppCode";
    private String kghost = null;

    public DapResponse getApplicationByNameAndTags(String applicationName, List<String> tags) {
        String url = this.datamapUrl + "/restful/standard/datamap/app/byNameAndTags";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (applicationName != null && !applicationName.isEmpty()) {
            params.put("applicationName", applicationName);
        } else {
            params.put("applicationName", "");
        }
        if (tags != null && !tags.isEmpty()) {
            params.put("tags", tags);
        } else {
            params.put("tags", new ArrayList<String>(){});
        }
        return (DapResponse)DwSpringHttpUtil.post((String)url, params, (ParameterizedTypeReference)new ParameterizedTypeReference<DapResponse<List<Application>>>(){});
    }

    public DapResponse<Map<String, List>> getDigitalStaff(Set<String> codeList, Set<String> enhanceCodeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0088.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.codeListEmpty", (Object[])new Object[0]));
        }
        HashMap<String, Set<String>> params = new HashMap<String, Set<String>>();
        params.put("codeList", codeList);
        params.put("enhanceCodeList", enhanceCodeList);
        String url = this.knowledgeGraphUrl + "/restful/service/knowledgegraph/app/queryDigitalStaffByCode";
        return (DapResponse)DwSpringHttpUtil.post((String)(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/app/queryDigitalStaffByCode"), params, (ParameterizedTypeReference)new ParameterizedTypeReference<DapResponse<Map<String, List>>>(){});
    }

    public DapResponse<List<Application>> getEnhancebyAppCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0089.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.delivery.codeEmpty", (Object[])new Object[0]));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        String url = this.knowledgeGraphUrl + "/restful/service/knowledgegraph/app/enhanceByAppCode?code={code}";
        return (DapResponse)DwSpringHttpUtil.get((String)url, (ParameterizedTypeReference)new ParameterizedTypeReference<DapResponse<List<Application>>>(){}, params);
    }

    public DapResponse<List<ApplicationRelationRespDTO>> postApplicationRelationsByCodesAndType(List<String> code, String type) {
        HashMap<String, ApplicationRelationReqByTypeAndCodesDTO> params = new HashMap<String, ApplicationRelationReqByTypeAndCodesDTO>();
        ApplicationRelationReqByTypeAndCodesDTO applicationRelationQueryDTO = new ApplicationRelationReqByTypeAndCodesDTO();
        applicationRelationQueryDTO.setCodes(code);
        applicationRelationQueryDTO.setType(type);
        params.put("applicationRelationQueryDTO", applicationRelationQueryDTO);
        String url = this.datamapUrl + "/restful/standard/datamap/app/applicationRelationsByCodesAndType";
        return (DapResponse)DwSpringHttpUtil.post((String)url, params, (ParameterizedTypeReference)new ParameterizedTypeReference<DapResponse<List<ApplicationRelationRespDTO>>>(){});
    }

    public DapResponse<ApplicationRelationRespDTO> getApplicationByTypeAndCode(String type, String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", type);
        params.put("code", code);
        String url = this.datamapUrl + "/restful/standard/datamap/app/applicationByTypeAndCode?type={type}&code={code}";
        return (DapResponse)DwSpringHttpUtil.get((String)url, (ParameterizedTypeReference)new ParameterizedTypeReference<DapResponse<ApplicationRelationRespDTO>>(){}, params);
    }
}

