/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.manager.iam.service;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.constant.TenantEnum;
import com.digiwin.athena.base.infrastructure.manager.iam.model.AppAuthoredDTO;
import com.digiwin.athena.base.infrastructure.manager.iam.model.CommonResultDTO;
import com.digiwin.athena.base.infrastructure.manager.iam.model.TenantAuthDTO;
import com.digiwin.athena.base.infrastructure.manager.iam.model.TenantDetailDTO;
import com.digiwin.athena.base.infrastructure.manager.iam.service.BaseIamService;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IamServiceImpl
implements BaseIamService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamServiceImpl.class);
    @Value(value="${athena.auth.uri:}")
    private String iamUri;
    @Resource
    private RestTemplate restTemplate;
    private static final String USER_PERMISSION_V2 = "/api/iam/v2/permission/user";
    private static final String USER_AUTHORED_PERMISSION_URL = "/api/iam/v2/user/application";
    private static final String ALL_USER_PERMISSION_URL = "/api/iam/v2/permission/users/apps/all";
    private static final String TENANT_APPLICATION_LIST_URL = "/api/iam/v2/tenant/application/list";
    private static final String QUERY_TENANT_AUTH_BY_EMAIL_URL = "/api/iam/v2/user/email/tenants/auth";
    private static final String CREATE_INDIVIDUAL_TENANT_AUTH_URL = "/api/iam/v2/user/individual/tenant/register";
    private static final String CREATE_TENANT_APP_AUTH_URL = "/api/iam/v2/user/tenant/user/auth";
    private static final String BATCH_QUERY_METADATA_ITEM_URL = "/api/iam/v2/usermetadata/user/get/batch";

    @Override
    public JSONObject getAllUserPermissionV2(AuthoredUser authoredUser, String appCode) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", authoredUser.getToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("userId", authoredUser.getUserId());
        requestMap.put("sysId", appCode);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        String url = this.iamUri + USER_PERMISSION_V2;
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            return (JSONObject)respEntity.getBody();
        }
        catch (Exception ex) {
            log.error("\u4eceIAM\u83b7\u53d6\u79df\u6237\uff08{}\uff09\u7684\u5e94\u7528\uff08{}\uff09\u6743\u9650\u914d\u7f6e\u51fa\u9519, url\uff1a{}", new Object[]{authoredUser.getTenantId(), appCode, url});
            return null;
        }
    }

    @Override
    public List<AppAuthoredDTO> getUserAuthoredApp(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        HttpEntity reqEntity = new HttpEntity(null, (MultiValueMap)headers);
        String url = this.iamUri + USER_AUTHORED_PERMISSION_URL;
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<AppAuthoredDTO>>(){}, new Object[0]);
            return (List)respEntity.getBody();
        }
        catch (Exception ex) {
            log.error("{}\uff0c\u83b7\u53d6\u7528\u6237\u5df2\u6388\u6743\u5e94\u7528\u5217\u8868\u5931\u8d25\uff0c \u7528\u6237token: {}, \u9519\u8bef\u5185\u5bb9\uff1a", new Object[]{AudcErrorCodeEnum.IAM_V2_USER_APPLICATION.getErrCode(), token, ex});
            throw ExceptionUtil.wrap((String)AudcErrorCodeEnum.IAM_V2_USER_APPLICATION.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public JSONArray batchQueryUserAppPermission(AuthoredUser authoredUser, List<String> authoredAppCodeList) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", authoredUser.getToken());
        HashMap<String, List<String>> requestMap = new HashMap<String, List<String>>();
        requestMap.put("userIds", Collections.singletonList(authoredUser.getUserId()));
        requestMap.put("sysIds", authoredAppCodeList);
        HttpEntity reqEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        String url = this.iamUri + ALL_USER_PERMISSION_URL;
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, JSONArray.class, new Object[0]);
            return (JSONArray)respEntity.getBody();
        }
        catch (Exception ex) {
            log.error("{}\uff0c\u6279\u91cf\u83b7\u53d6\u7528\u6237\u6388\u6743\u5e94\u7528\u6743\u9650\u914d\u7f6e\u5931\u8d25\uff0c\u7528\u6237token: {}\uff0c\u8bf7\u6c42body\u4f53\uff1a{}\uff0c\u9519\u8bef\u5185\u5bb9\uff1a", new Object[]{AudcErrorCodeEnum.IAM_V2_PERMISSION_USERS_APPS_ALL.getErrCode(), authoredUser.getToken(), JsonUtils.objectToString(requestMap), ex});
            throw ExceptionUtil.wrap((String)AudcErrorCodeEnum.IAM_V2_PERMISSION_USERS_APPS_ALL.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public Map<String, Object> getTenantAuth(AuthoredUser authoredUser, String email, String telephone, String appId, Integer tenantType) {
        if (StringUtil.isEmpty((String)email) && StringUtil.isEmpty((String)telephone)) {
            return null;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String url = this.iamUri + QUERY_TENANT_AUTH_BY_EMAIL_URL;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", authoredUser.getToken());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("email", email);
        param.put("telephone", telephone);
        param.put("appId", StringUtil.isNotEmpty((String)appId) ? appId : "Athena");
        param.put("tenantType", tenantType != null ? tenantType.intValue() : TenantEnum.INDIVIDUAL.getType());
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            log.info("getTenantAuth post iam begin, URL:{}, param:{}", (Object)url, (Object)JsonUtils.objectToString((Object)httpEntity));
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, CommonResultDTO.class, new HashMap());
            log.info("getTenantAuth post iam end, result:{}", (Object)JsonUtils.objectToString((Object)responseEntity));
            if (Objects.isNull(responseEntity) || Objects.isNull(responseEntity.getBody()) || Objects.isNull(((CommonResultDTO)responseEntity.getBody()).getData()) || responseEntity.getStatusCodeValue() != 200) {
                resultMap.put("status", -1);
                log.error("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25");
                return resultMap;
            }
            TenantAuthDTO tenantAuthDTO = (TenantAuthDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)((CommonResultDTO)responseEntity.getBody()).getData()), TenantAuthDTO.class);
            List<TenantDetailDTO> tenantDTOS = tenantAuthDTO.getTenants();
            if (CollectionUtils.isEmpty(tenantDTOS)) {
                resultMap.put("status", 0);
                log.info("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff1a\u6ca1\u6709\u4e2a\u4eba\u79df\u6237");
                return resultMap;
            }
            TenantDetailDTO tenantDTO = tenantDTOS.get(0);
            if (!tenantDTO.getIsTenantAuth().booleanValue() || !tenantDTO.getIsUserAuth().booleanValue()) {
                resultMap.put("status", 1);
                resultMap.put("userId", tenantAuthDTO.getUserId());
                resultMap.put("tenantId", tenantDTO.getId());
                resultMap.put("isTenantAuth", tenantDTO.getIsTenantAuth());
                resultMap.put("isUserAuth", tenantDTO.getIsUserAuth());
                log.info("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff08\u6ca1\u6709\u6388\u6743\uff09\uff1a{}", (Object)JsonUtils.objectToString((Object)tenantAuthDTO));
                return resultMap;
            }
            resultMap.put("status", 2);
            resultMap.put("userId", tenantAuthDTO.getUserId());
            resultMap.put("tenantId", tenantDTO.getId());
            resultMap.put("isTenantAuth", tenantDTO.getIsTenantAuth());
            resultMap.put("isUserAuth", tenantDTO.getIsUserAuth());
        }
        catch (Exception e) {
            resultMap.put("status", -1);
            log.error("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return resultMap;
    }

    @Override
    public Map<String, String> registerTenant(AuthoredUser authoredUser, String email, String telephone, String appId, String strategySid, String strategyCode) {
        if (StringUtil.isEmpty((String)email) && StringUtil.isEmpty((String)telephone)) {
            return null;
        }
        Map<String, String> resultMap = new HashMap<String, String>();
        String url = this.iamUri + CREATE_INDIVIDUAL_TENANT_AUTH_URL;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", authoredUser.getToken());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("email", email);
        param.put("telephone", telephone);
        param.put("appId", StringUtil.isNotEmpty((String)appId) ? appId : "Athena");
        param.put("strategyCode", StringUtil.isNotEmpty((String)strategyCode) ? strategyCode : "athena_light_01");
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            log.info("registerTenant post iam begin, URL:{}, param:{}", (Object)url, (Object)JsonUtils.objectToString((Object)httpEntity));
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, CommonResultDTO.class, new HashMap());
            log.info("registerTenant post iam end, result:{}", (Object)JsonUtils.objectToString((Object)responseEntity));
            if (Objects.nonNull(responseEntity) && Objects.nonNull(responseEntity.getBody()) && Objects.nonNull(((CommonResultDTO)responseEntity.getBody()).getData()) && responseEntity.getStatusCodeValue() == 200) {
                Object data = ((CommonResultDTO)responseEntity.getBody()).getData();
                resultMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)data), Map.class);
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u4e2a\u4eba\u79df\u6237\u4ee5\u53ca\u6388\u6743\u5931\u8d25", (Throwable)e);
        }
        return resultMap;
    }

    @Override
    public Boolean authorizeUser(AuthoredUser authoredUser, String tenantId, String email, String telephone, String appId, String strategySid, String strategyCode, Boolean isTenantAuth) {
        Boolean result = true;
        if (StringUtil.isEmpty((String)email) && StringUtil.isEmpty((String)tenantId)) {
            return null;
        }
        String url = this.iamUri + CREATE_TENANT_APP_AUTH_URL;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantId", tenantId);
        param.put("email", email);
        param.put("telephone", telephone);
        param.put("appId", StringUtil.isNotEmpty((String)appId) ? appId : "Athena");
        param.put("strategyCode", StringUtil.isNotEmpty((String)strategyCode) ? strategyCode : "athena_light_01");
        param.put("isTenantAuth", isTenantAuth);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            log.info("authorizeUser post iam begin, URL:{}, param:{}", (Object)url, (Object)JsonUtils.objectToString((Object)httpEntity));
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, CommonResultDTO.class, new HashMap());
            log.info("authorizeUser post iam end, result:{}", (Object)JsonUtils.objectToString((Object)responseEntity));
            if (Objects.nonNull(responseEntity) && Objects.nonNull(responseEntity.getBody()) && Objects.nonNull(((CommonResultDTO)responseEntity.getBody()).getData()) && responseEntity.getStatusCodeValue() == 200) {
                result = Boolean.valueOf(((CommonResultDTO)responseEntity.getBody()).getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u7ed9\u6307\u5b9a\u79df\u6237\u4e0b\u7684\u7528\u6237\u6388\u6743\u6307\u5b9a\u5e94\u7528\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<Map> batchQueryUserMetadataItem(List<String> userIdList, String tenantSid, String key, String catalogId) {
        String url = this.iamUri + BATCH_QUERY_METADATA_ITEM_URL;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userIdList", userIdList);
        param.put("tenantSid", tenantSid);
        param.put("key", key);
        param.put("catalogId", catalogId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        List resultList = new ArrayList();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, CommonResultDTO.class, new HashMap());
            if (Objects.nonNull(responseEntity) && Objects.nonNull(responseEntity.getBody()) && Objects.nonNull(((CommonResultDTO)responseEntity.getBody()).getData()) && responseEntity.getStatusCodeValue() == 200) {
                Object data = ((CommonResultDTO)responseEntity.getBody()).getData();
                resultList = JsonUtils.jsonToListObject((String)JsonUtils.objectToString((Object)data), Map.class);
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u4e2a\u4eba\u79df\u6237\u4ee5\u53ca\u6388\u6743\u5931\u8d25", (Throwable)e);
        }
        return null != resultList ? resultList : Lists.newArrayList();
    }

    @Override
    public Integer queryUserType(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.iamUri + "/api/iam/v2/query/user";
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
            Map body = (Map)responseEntity.getBody();
            if (body == null) {
                return null;
            }
            return (Integer)body.get("userType");
        }
        catch (Exception ex) {
            log.error("{}, body: {}, error: ", new Object[]{AudcErrorCodeEnum.IAM_V2_QUERY_USER.getErrCode(), JsonUtils.objectToString(param), ex});
            return null;
        }
    }
}

