package com.digiwin.athena.base.infrastructure.meta.po.visit;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/11/04 14:25:19
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "user_visit_config")
public class VisitInfoData extends BaseEntity<VisitInfoData> implements Serializable {

    /**
     * 主键ID
     */
    @TableId()
    private Long id;
    /**
     * 公司或者组织名称
     */
    private String userId;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 模块号
     */
    private String moduleNo;
    /**
     * 详情
     */
    private String detail;

    /**
     * 备注
     */
    private String remark;

}
