/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.importstatistics.util.excel;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.entity.valueobject.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.atdm.importstatistics.entity.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.atdm.importstatistics.entity.valueobject.MetaDataType;
import com.digiwin.athena.atdm.importstatistics.util.excel.CellTypeHolder;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelParserBean;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelTypeEnum;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class ExcelUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    public static final String MAIN_SHEET_NAME = "sheet1";

    private static String handleLocale(String locale) {
        if (StringUtils.isEmpty((String)locale)) {
            return "zh_CN";
        }
        if (locale.equals("en")) {
            return "en_US";
        }
        return locale;
    }

    public static XSSFRichTextString addRequiredMark(XSSFWorkbook wb, String s) {
        XSSFFont font = wb.createFont();
        font.setColor((short)10);
        font.setBold(true);
        XSSFRichTextString str = new XSSFRichTextString("*" + s);
        str.applyFont(0, 1, (Font)font);
        return str;
    }

    public static void excelRuleStringLength(String locale, Sheet sheet, int min, int max, int firstRow, int lastRow, int firstCol, int lastCol) {
        locale = ExcelUtil.handleLocale(locale);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = helper.createNumericConstraint(6, 0, String.valueOf(min), String.valueOf(max));
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        String title = MessageUtil.getMessageByLocale((String)"excel.string.title.length", (String)locale, (Object[])new Object[]{max});
        String content = MessageUtil.getMessageByLocale((String)"excel.string.content.length", (String)locale, (Object[])new Object[]{max});
        dataValidation.createPromptBox(title, content);
        dataValidation.createErrorBox(title, content);
        dataValidation.setShowErrorBox(true);
        dataValidation.setEmptyCellAllowed(true);
        dataValidation.setSuppressDropDownArrow(true);
        dataValidation.setShowPromptBox(true);
        dataValidation.setErrorStyle(0);
        sheet.addValidationData(dataValidation);
    }

    public static void excelRuleDateFormat(String locale, Sheet sheet, String start, String end, String format, int firstRow, int lastRow, int firstCol, int lastCol) {
        locale = ExcelUtil.handleLocale(locale);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = helper.createDateConstraint(6, start, end, format);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        String content = MessageUtil.getMessageByLocale((String)"excel.date.content.enterCorrect", (String)locale, (Object[])new Object[]{format});
        dataValidation.createPromptBox("", content);
        dataValidation.createErrorBox(MessageUtil.getMessageByLocale((String)"excel.date.title.enterCorrect", (String)locale, (Object[])new Object[0]), content);
        dataValidation.setShowErrorBox(true);
        dataValidation.setEmptyCellAllowed(true);
        dataValidation.setSuppressDropDownArrow(true);
        dataValidation.setShowPromptBox(true);
        dataValidation.setErrorStyle(0);
        sheet.addValidationData(dataValidation);
    }

    public static void excelRuleUniqueue(String locale, Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        locale = ExcelUtil.handleLocale(locale);
        Row row = sheet.getRow(0);
        Cell cell = row.getCell(firstCol);
        String r = ((XSSFCell)cell).getCTCell().getR();
        r = r.substring(0, 1);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = helper.createCustomConstraint(MessageFormat.format("COUNTIF({0}:{0},{0}2)=1", r));
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        dataValidation.createErrorBox("\u9519\u8bef\uff1a", "\u8d4b\u503c\u5c5e\u6027\u5217\u4e0d\u5141\u8bb8\u91cd\u590d");
        dataValidation.setShowErrorBox(true);
        dataValidation.setEmptyCellAllowed(true);
        dataValidation.setSuppressDropDownArrow(true);
        dataValidation.setShowPromptBox(true);
        dataValidation.setErrorStyle(0);
        sheet.addValidationData(dataValidation);
    }

    public static void excelRuleSelect(String locale, Sheet sheet, String[] rule, int firstRow, int lastRow, int firstCol, int lastCol) {
        locale = ExcelUtil.handleLocale(locale);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = helper.createExplicitListConstraint(rule);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        String itemStr = MessageUtil.getMessageByLocale((String)"excel.select.item.selectCorrect", (String)locale, (Object[])new Object[]{Arrays.asList(rule).toString()});
        String title = MessageUtil.getMessageByLocale((String)"excel.select.title.selectCorrect", (String)locale, (Object[])new Object[0]);
        String content = MessageUtil.getMessageByLocale((String)"excel.select.content.selectCorrect", (String)locale, (Object[])new Object[]{Arrays.asList(rule).toString()});
        dataValidation.createPromptBox(itemStr, itemStr);
        dataValidation.createErrorBox(title, content);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        dataValidation.setEmptyCellAllowed(true);
        dataValidation.setShowPromptBox(true);
        dataValidation.setErrorStyle(0);
        sheet.addValidationData(dataValidation);
    }

    public static void excelRuleNumberBetween(String locale, Sheet sheet, int min, int max, int firstRow, int lastRow, int firstCol, int lastCol) {
        locale = ExcelUtil.handleLocale(locale);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = helper.createIntegerConstraint(0, String.valueOf(min), String.valueOf(max));
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        dataValidation.createPromptBox("", MessageUtil.getMessage((String)"delivery.inputValidData", (Object[])new Object[0]));
        dataValidation.createErrorBox(MessageUtil.getMessage((String)"delivery.dataValueError", (Object[])new Object[0]), MessageUtil.getMessage((String)"delivery.inputValueTips", (Object[])new Object[]{min, max}));
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        dataValidation.setShowErrorBox(true);
        dataValidation.setShowPromptBox(true);
        dataValidation.setEmptyCellAllowed(true);
        dataValidation.setSuppressDropDownArrow(true);
        dataValidation.setErrorStyle(0);
        sheet.addValidationData(dataValidation);
    }

    public static void excelRuleIsNumber(String locale, Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        locale = ExcelUtil.handleLocale(locale);
        String isNumber = "=ISNUMBER(INDIRECT(ADDRESS(ROW(),COLUMN())))";
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = helper.createCustomConstraint(isNumber);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        dataValidation.createPromptBox("", MessageUtil.getMessageByLocale((String)"excel.number.content.isNumber", (String)locale, (Object[])new Object[0]));
        dataValidation.createErrorBox(MessageUtil.getMessageByLocale((String)"excel.number.title.isNumber", (String)locale, (Object[])new Object[0]), MessageUtil.getMessageByLocale((String)"excel.number.content.isNumber", (String)locale, (Object[])new Object[0]));
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        dataValidation.setShowErrorBox(true);
        dataValidation.setShowPromptBox(true);
        dataValidation.setEmptyCellAllowed(true);
        dataValidation.setSuppressDropDownArrow(true);
        dataValidation.setErrorStyle(0);
        sheet.addValidationData(dataValidation);
    }

    public static ExcelParserBean parser(String filePath) throws IOException {
        ExcelParserBean parserBean = new ExcelParserBean();
        parserBean.setFilePath(filePath);
        File file = new File(filePath);
        if (!file.exists()) {
            throw new IllegalArgumentException(MessageUtil.getMessage((String)"delivery.excelPathError", (Object[])new Object[0]));
        }
        FileInputStream inputStream = new FileInputStream(new File(filePath));
        parserBean.setInput(inputStream);
        ExcelParserBean parser = ExcelUtil.parser(parserBean);
        if (inputStream != null) {
            ((InputStream)inputStream).close();
        }
        return parser;
    }

    public static ExcelParserBean parser(InputStream input, String fileName) throws IOException {
        ExcelParserBean parserBean = new ExcelParserBean();
        parserBean.setInput(input);
        parserBean.setFilePath(fileName);
        return ExcelUtil.parser(parserBean);
    }

    public static ExcelParserBean parser(ExcelParserBean parserBean) {
        return ExcelUtil.parser(parserBean, null, 0);
    }

    public static ExcelParserBean parser(ExcelParserBean parserBean, List<CellType> cellTypes, int skipHeaders) {
        ExcelUtil.setDefaultExcelType(parserBean);
        Workbook workbook = ExcelUtil.createWorkbook(parserBean);
        Map<String, List<List<Object>>> parseSheet = null == cellTypes ? ExcelUtil.parseSheet(workbook) : ExcelUtil.parseSheet(workbook, cellTypes, skipHeaders);
        parserBean.setData(parseSheet);
        ExcelUtil.realeaseResources(parserBean, workbook);
        return parserBean;
    }

    public static ExcelParserBean parserNew(ExcelParserBean parserBean, List<CellType> cellTypes, int skipHeaders) {
        ExcelUtil.setDefaultExcelType(parserBean);
        Workbook workbook = ExcelUtil.createWorkbook(parserBean);
        Map<String, List<List<Object>>> parseSheet = null == cellTypes ? ExcelUtil.parseSheet(workbook) : ExcelUtil.parseSheet(workbook, cellTypes, skipHeaders);
        parserBean.setData(parseSheet);
        ExcelUtil.realeaseResources(parserBean, workbook);
        return parserBean;
    }

    public static ExcelParserBean parser(ExcelParserBean parserBean, GetActionLocaleResponseDTO getActionLocaleResponseDTO, int skipHeaders, int flag) {
        Map<String, List<List<Object>>> parseSheet;
        ExcelUtil.setDefaultExcelType(parserBean);
        Workbook workbook = ExcelUtil.createWorkbook(parserBean);
        try {
            parseSheet = null == getActionLocaleResponseDTO ? ExcelUtil.parseSheet(workbook) : ExcelUtil.parseSheet(workbook, skipHeaders, getActionLocaleResponseDTO);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790Excel\u62a5\u9519\uff01e:", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0116.getErrCode(), (String)MessageUtil.getMessageByLocale((String)"upload.template.error", (String)LocaleContextHolder.getLocale().toString(), (Object[])new Object[0]));
        }
        parserBean.setData(parseSheet);
        ExcelUtil.realeaseResources(parserBean, workbook);
        return parserBean;
    }

    public static ExcelParserBean parserHeader(ExcelParserBean parserBean, int headerRow) {
        ExcelUtil.setDefaultExcelType(parserBean);
        Workbook workbook = ExcelUtil.createWorkbook(parserBean);
        HashMap<String, List<List<Object>>> data = new HashMap<String, List<List<Object>>>();
        Iterator sheetIterator = workbook.iterator();
        int sheetCount = 0;
        while (sheetIterator.hasNext()) {
            ArrayList<List<Object>> sheetData = new ArrayList<List<Object>>();
            Sheet sheet = (Sheet)sheetIterator.next();
            Iterator rowIterator = sheet.iterator();
            int rowNumber = 0;
            while (rowIterator.hasNext()) {
                if (sheetCount > 1 && rowNumber == 0) continue;
                Row row = (Row)rowIterator.next();
                if (headerRow > rowNumber + 1) {
                    ++rowNumber;
                    continue;
                }
                if (headerRow != rowNumber + 1) break;
                List<Object> rowData = ExcelUtil.parseRow(row);
                sheetData.add(rowData);
                ++rowNumber;
            }
            data.put(sheet.getSheetName(), sheetData);
            ++sheetCount;
        }
        parserBean.setData(data);
        return parserBean;
    }

    public static void setDefaultExcelType(ExcelParserBean parserBean) {
        String filePath = parserBean.getFilePath();
        String fileExtension = ExcelUtil.getFileExtension(filePath);
        ExcelTypeEnum excelType = parserBean.getExcelType();
        if (excelType == null && fileExtension == null) {
            excelType = ExcelTypeEnum.XLS;
        } else if (excelType == null && fileExtension != null) {
            if (fileExtension.equalsIgnoreCase(ExcelTypeEnum.XLS.name())) {
                excelType = ExcelTypeEnum.XLS;
            } else if (fileExtension.equalsIgnoreCase(ExcelTypeEnum.XLSX.name())) {
                excelType = ExcelTypeEnum.XLSX;
            }
        }
        parserBean.setExcelType(excelType);
    }

    public static Workbook createWorkbook(ExcelParserBean parserBean) {
        Object wb = null;
        ExcelTypeEnum excelType = parserBean.getExcelType();
        try {
            wb = ExcelTypeEnum.XLS.equals((Object)excelType) ? new HSSFWorkbook(parserBean.getInput()) : (ExcelTypeEnum.XLSX.equals((Object)excelType) ? new XSSFWorkbook(parserBean.getInput()) : new HSSFWorkbook(parserBean.getInput()));
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return wb;
    }

    protected static Map<String, List<List<Object>>> parseSheet(Workbook workbook) {
        return ExcelUtil.parseSheet(workbook, null, 0);
    }

    protected static Map<String, List<List<Object>>> parseSheet(Workbook workbook, List<CellType> cellTypes, int skipHeaders) {
        HashMap<String, List<List<Object>>> data = new HashMap<String, List<List<Object>>>();
        Iterator sheetIterator = workbook.iterator();
        int sheetCount = 0;
        while (sheetIterator.hasNext()) {
            ArrayList<List<Object>> sheetData = new ArrayList<List<Object>>();
            Sheet sheet = (Sheet)sheetIterator.next();
            Map<String, Integer[]> map = ExcelUtil.getMergedRegionMap(sheet);
            Sheet sheetExcepNullRow = ExcelUtil.getAccuracyContextNum(sheet, map);
            Iterator rowIterator = sheetExcepNullRow.iterator();
            for (int rowNumber = 0; rowIterator.hasNext() && (sheetCount <= 1 || rowNumber != 0); ++rowNumber) {
                Row row = (Row)rowIterator.next();
                List<Object> rowData = skipHeaders <= rowNumber + 1 ? ExcelUtil.parseRow(row) : (null == cellTypes ? ExcelUtil.parseRow(row) : ExcelUtil.parseRow(row, cellTypes));
                sheetData.add(rowData);
            }
            data.put(sheetExcepNullRow.getSheetName(), sheetData);
            ++sheetCount;
        }
        return data;
    }

    protected static Map<String, List<List<Object>>> parseSheet(Workbook workbook, int skipHeaders, GetActionLocaleResponseDTO getActionLocaleResponseDTO) {
        List apiDataFieldLocaleMetadataDTOS = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(getActionLocaleResponseDTO.getRequest().getParameters().get(0).getField()), ApiDataFieldLocaleMetadataDTO.class);
        LinkedHashMap<String, List<List<Object>>> data = new LinkedHashMap<String, List<List<Object>>>();
        Iterator sheetIterator = workbook.iterator();
        int sheetCount = 0;
        while (sheetIterator.hasNext()) {
            Sheet sheet = (Sheet)sheetIterator.next();
            String sheetName = ExcelUtil.getSheetNameInParens(sheet.getSheetName());
            if (data.containsKey(sheetName)) continue;
            ExcelUtil.doParseSheet(workbook, sheetCount, skipHeaders, sheet, data, apiDataFieldLocaleMetadataDTOS);
            ++sheetCount;
        }
        return data;
    }

    public static void doParseSheet(Workbook workbook, int sheetCount, int skipHeaders, Sheet sheet, Map<String, List<List<Object>>> data, List<ApiDataFieldLocaleMetadataDTO> apiDataFieldLocaleMetadataDTOS) {
        ArrayList<List<Object>> sheetData = new ArrayList<List<Object>>();
        Map<String, Integer[]> map = ExcelUtil.getMergedRegionMap(sheet);
        Sheet sheetExcepNullRow = ExcelUtil.getAccuracyContextNum(sheet, map);
        String sheetName = ExcelUtil.getSheetNameInParens(sheetExcepNullRow.getSheetName());
        Iterator rowIterator = sheetExcepNullRow.iterator();
        int rowNumber = 0;
        List<Object> headerList = new ArrayList();
        while (rowIterator.hasNext()) {
            List<Object> rowData;
            Row row = (Row)rowIterator.next();
            if (skipHeaders > rowNumber + 1) {
                rowData = ExcelUtil.parseRow(row);
            } else if (skipHeaders == rowNumber + 1) {
                rowData = ExcelUtil.parseRow(row);
                headerList = rowData;
            } else {
                rowData = ExcelUtil.parseRow(sheetCount > 0 ? sheetName : MAIN_SHEET_NAME, row, apiDataFieldLocaleMetadataDTOS, headerList);
            }
            sheetData.add(rowData);
            ++rowNumber;
        }
        if (!MAIN_SHEET_NAME.equals(sheetExcepNullRow.getSheetName())) {
            data.put(sheetName, sheetData);
        }
        int totalNum = workbook.getNumberOfSheets();
        if (totalNum > sheetCount + 1) {
            Sheet nextSheet = workbook.getSheetAt(sheetCount + 1);
            Sheet nextSheetExcepNullRow = ExcelUtil.getAccuracyContextNum(nextSheet, map);
            String nextSheetName = ExcelUtil.getSheetNameInParens(nextSheetExcepNullRow.getSheetName());
            for (ApiDataFieldLocaleMetadataDTO metadataDTO : apiDataFieldLocaleMetadataDTOS) {
                if (!metadataDTO.getData_name().equals(nextSheetName) || !metadataDTO.getIs_array()) continue;
                List<ApiDataFieldLocaleMetadataDTO> businessKeyFields = ExcelUtil.getBusinessKeyFields(apiDataFieldLocaleMetadataDTOS);
                List<ApiDataFieldLocaleMetadataDTO> bodyMetadataDtoList = metadataDTO.getField();
                bodyMetadataDtoList.addAll(businessKeyFields);
                ExcelUtil.doParseSheet(workbook, ++sheetCount, skipHeaders, nextSheet, data, bodyMetadataDtoList);
            }
        }
    }

    public static List<Map> readDataForImport(Sheet sheet, List<ApiDataFieldLocaleMetadataDTO> apiDataFieldLocaleMetadataDTOS) {
        Map<String, Integer[]> map = ExcelUtil.getMergedRegionMap(sheet);
        Sheet sheetExcepNullRow = ExcelUtil.getAccuracyContextNum(sheet, map);
        if (CollectionUtils.isEmpty(apiDataFieldLocaleMetadataDTOS)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0086.getErrCode(), (String)MessageUtil.getMessage((String)"basedata.apiNoDF", (Object[])new Object[0]));
        }
        Map<String, String> metaMap = apiDataFieldLocaleMetadataDTOS.stream().collect(Collectors.toMap(ApiDataFieldLocaleMetadataDTO::getData_name, ApiDataFieldLocaleMetadataDTO::getData_type, (item1, item2) -> item1));
        LinkedList<CellTypeHolder> cellTypeHolders = new LinkedList<CellTypeHolder>();
        LinkedList<String> headerKeys = new LinkedList<String>();
        Row headRow2 = sheetExcepNullRow.getRow(1);
        int cellStartIdx = 0;
        while (null != headRow2.getCell(cellStartIdx)) {
            String key = headRow2.getCell(cellStartIdx).getStringCellValue();
            headerKeys.add(key);
            ++cellStartIdx;
        }
        block5: for (int i = 0; i < headerKeys.size(); ++i) {
            if (null == metaMap.get(headerKeys.get(i))) continue;
            CellTypeHolder cellTypeHolder = new CellTypeHolder();
            cellTypeHolder.setHeaderKey((String)headerKeys.get(i));
            cellTypeHolder.setIndex(i);
            cellTypeHolder.setMetaDataType(MetaDataType.valueOf(metaMap.get(headerKeys.get(i)).toUpperCase()));
            switch (MetaDataType.valueOf(metaMap.get(headerKeys.get(i)).toUpperCase())) {
                case NUMERIC: 
                case NUMBER: {
                    cellTypeHolder.setCellType(CellType.NUMERIC);
                    cellTypeHolders.add(cellTypeHolder);
                    continue block5;
                }
                case BOOLEAN: {
                    cellTypeHolder.setCellType(CellType.BOOLEAN);
                    cellTypeHolders.add(cellTypeHolder);
                    continue block5;
                }
                default: {
                    cellTypeHolder.setCellType(CellType.STRING);
                    cellTypeHolders.add(cellTypeHolder);
                }
            }
        }
        if (CollectionUtils.isEmpty(cellTypeHolders)) {
            log.error("\u89e3\u6790Excel\u7684\u680f\u4f4d\u4e3a\u7a7a\uff01");
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0116.getErrCode(), (String)MessageUtil.getMessageByLocale((String)"upload.template.error", (String)LocaleContextHolder.getLocale().toString(), (Object[])new Object[0]));
        }
        LinkedList<Map> data = new LinkedList<Map>();
        int rowStartIdx = 2;
        while (null != sheetExcepNullRow.getRow(rowStartIdx)) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            Row row = sheetExcepNullRow.getRow(rowStartIdx);
            for (int i = 0; i < cellTypeHolders.size(); ++i) {
                CellTypeHolder cellTypeHolder = (CellTypeHolder)cellTypeHolders.get(i);
                Cell cell = row.getCell(cellTypeHolder.getIndex());
                Object cellObj = null;
                if (cell != null) {
                    cellObj = ExcelUtil.parseCell(cell, cellTypeHolder.getCellType(), cellTypeHolder.getMetaDataType());
                }
                rowData.put(cellTypeHolder.getHeaderKey(), cellObj);
            }
            data.add(rowData);
            ++rowStartIdx;
        }
        return data;
    }

    public static Map<String, Integer[]> getMergedRegionMap(Sheet sheet) {
        HashMap<String, Integer[]> result = new HashMap<String, Integer[]>();
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            Integer[] firstRowNumberAndCellNumber = new Integer[]{firstRow, firstColumn};
            for (int currentRowNumber = firstRow; currentRowNumber <= lastRow; ++currentRowNumber) {
                for (int currentCellNumber = firstColumn; currentCellNumber <= lastColumn; ++currentCellNumber) {
                    result.put(currentRowNumber + "_" + currentCellNumber, firstRowNumberAndCellNumber);
                }
            }
        }
        return result;
    }

    public static Sheet getAccuracyContextNum(Sheet sheetOld, Map<String, Integer[]> mergedRegionMap) {
        Sheet sheet = sheetOld;
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) {
                int lastRowNum = sheet.getLastRowNum();
                if (i >= 0 && i < lastRowNum) {
                    sheet.shiftRows(i + 1, lastRowNum, -1);
                }
                --i;
                continue;
            }
            int cellNum = row.getLastCellNum();
            boolean flag = false;
            for (int j = 0; j < cellNum; ++j) {
                Integer[] firstRowNumberAndCellNumber = mergedRegionMap.get(i + "_" + j);
                if (firstRowNumberAndCellNumber == null) continue;
                flag = true;
            }
            if (!ExcelUtil.isRowEmpty(row) || flag || !ExcelUtil.isRowEmpty(row)) continue;
            int lastRowNum = sheet.getLastRowNum();
            if (i >= 0 && i < lastRowNum) {
                sheet.shiftRows(i + 1, lastRowNum, -1);
            }
            if (i == lastRowNum && row != null) {
                sheet.removeRow(row);
            }
            --i;
        }
        return sheet;
    }

    protected static boolean isRowEmpty(Row row) {
        if (row == null) {
            return true;
        }
        int firstCellNum = row.getFirstCellNum();
        short lastCellNum = row.getLastCellNum();
        int nullCellNum = 0;
        for (int c = firstCellNum; c < lastCellNum; ++c) {
            String cellValue;
            Cell cell = row.getCell(c);
            if (null == cell || 3 == cell.getCellType()) {
                ++nullCellNum;
                continue;
            }
            if (!CellType.STRING.equals((Object)cell.getCellTypeEnum()) || !StringUtils.isEmpty((String)(cellValue = cell.getStringCellValue().trim()))) continue;
            ++nullCellNum;
        }
        return nullCellNum == lastCellNum - firstCellNum;
    }

    protected static List<Object> parseRow(Row row) {
        return ExcelUtil.parseRow(row, null);
    }

    protected static List<Object> parseRow(Row row, List<CellType> cellTypes) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        if (null != cellTypes && row.getLastCellNum() != cellTypes.size()) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0083.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.dataTypeNotMatchUnit", (Object[])new Object[0]));
        }
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            Object cellObj = null;
            if (cell != null) {
                cellObj = null == cellTypes ? ExcelUtil.parseCell(cell) : ExcelUtil.parseCell(cell, cellTypes.get(i));
            }
            rowData.add(cellObj);
        }
        return rowData;
    }

    protected static List<Object> parseRow(String sheetName, Row row, List<ApiDataFieldLocaleMetadataDTO> apiDataFieldLocaleMetadataDTOS, List headerList) {
        List<String> businessKeys;
        if (CollectionUtils.isEmpty((Collection)headerList)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0084.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.headerListEmpty", (Object[])new Object[0]));
        }
        if (!MAIN_SHEET_NAME.equals(sheetName) && CollectionUtils.isEmpty(businessKeys = ExcelUtil.getBusinessKeys(apiDataFieldLocaleMetadataDTOS))) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0085.getErrCode(), (String)MessageUtil.getMessage((String)"basedata.apiNoBusinessKey", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(apiDataFieldLocaleMetadataDTOS)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0086.getErrCode(), (String)MessageUtil.getMessage((String)"basedata.apiNoDF", (Object[])new Object[0]));
        }
        Map<String, String> metaMap = apiDataFieldLocaleMetadataDTOS.stream().collect(Collectors.toMap(ApiDataFieldLocaleMetadataDTO::getData_name, ApiDataFieldLocaleMetadataDTO::getData_type, (item1, item2) -> item1));
        LinkedList<CellTypeHolder> cellTypeHolders = new LinkedList<CellTypeHolder>();
        block4: for (int i = 0; i < headerList.size(); ++i) {
            if (null == metaMap.get(headerList.get(i))) continue;
            CellTypeHolder cellTypeHolder = new CellTypeHolder();
            cellTypeHolder.setIndex(i);
            cellTypeHolder.setMetaDataType(MetaDataType.valueOf(metaMap.get(headerList.get(i)).toUpperCase()));
            switch (MetaDataType.valueOf(metaMap.get(headerList.get(i)).toUpperCase())) {
                case NUMERIC: 
                case NUMBER: {
                    cellTypeHolder.setCellType(CellType.NUMERIC);
                    cellTypeHolders.add(cellTypeHolder);
                    continue block4;
                }
                case BOOLEAN: {
                    cellTypeHolder.setCellType(CellType.BOOLEAN);
                    cellTypeHolders.add(cellTypeHolder);
                    continue block4;
                }
                default: {
                    cellTypeHolder.setCellType(CellType.STRING);
                    cellTypeHolders.add(cellTypeHolder);
                }
            }
        }
        if (CollectionUtils.isEmpty(cellTypeHolders)) {
            log.error("\u89e3\u6790Excel\u7684\u680f\u4f4d\u4e3a\u7a7a\uff01");
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0116.getErrCode(), (String)MessageUtil.getMessageByLocale((String)"upload.template.error", (String)LocaleContextHolder.getLocale().toString(), (Object[])new Object[0]));
        }
        ArrayList<Object> rowData = new ArrayList<Object>();
        for (int i = 0; i < cellTypeHolders.size(); ++i) {
            Cell cell = row.getCell(((CellTypeHolder)cellTypeHolders.get(i)).getIndex());
            Object cellObj = null;
            if (cell != null) {
                cellObj = ExcelUtil.parseCell(cell, ((CellTypeHolder)cellTypeHolders.get(i)).getCellType(), ((CellTypeHolder)cellTypeHolders.get(i)).getMetaDataType());
            }
            rowData.add(cellObj);
        }
        return rowData;
    }

    private static List<ApiDataFieldLocaleMetadataDTO> getBusinessKeyFields(List<ApiDataFieldLocaleMetadataDTO> apiDataFieldLocaleMetadataDTOS) {
        return apiDataFieldLocaleMetadataDTOS.stream().filter(item -> item.getIs_businesskey()).collect(Collectors.toList());
    }

    private static List<ApiDataFieldLocaleMetadataDTO> getSheetField(String sheetName, List<ApiDataFieldLocaleMetadataDTO> apiDataFieldLocaleMetadataDTOS) {
        if (CollectionUtils.isEmpty(apiDataFieldLocaleMetadataDTOS)) {
            return null;
        }
        if (!CollectionUtils.isEmpty(apiDataFieldLocaleMetadataDTOS = apiDataFieldLocaleMetadataDTOS.stream().filter(item -> item.getData_name().equals(sheetName)).collect(Collectors.toList()))) {
            return apiDataFieldLocaleMetadataDTOS.get(0).getField();
        }
        return null;
    }

    private static List<String> getBusinessKeys(List<ApiDataFieldLocaleMetadataDTO> apiDataFieldLocaleMetadataDTOS) {
        LinkedList<String> businessKeys = new LinkedList<String>();
        for (ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO : apiDataFieldLocaleMetadataDTOS) {
            if (!apiDataFieldLocaleMetadataDTO.getIs_businesskey()) continue;
            businessKeys.add(apiDataFieldLocaleMetadataDTO.getData_name());
        }
        return businessKeys;
    }

    protected static Object parseCell(Cell cell, CellType metaCellType, MetaDataType metaType) {
        Object obj;
        CellType cellType = cell.getCellTypeEnum();
        switch (cellType) {
            case FORMULA: {
                try {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        obj = date.getYear() + 1900 + "-" + (date.getMonth() + 1) + "-" + date.getDate();
                        break;
                    }
                    obj = String.valueOf(cell.getNumericCellValue());
                }
                catch (IllegalStateException e) {
                    obj = String.valueOf(cell.getRichStringCellValue());
                }
                break;
            }
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case NUMERIC: {
                SimpleDateFormat sdf;
                short number58 = 58;
                switch (metaType) {
                    case DATE: {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                        break;
                    }
                    case DATETIME: {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        break;
                    }
                    case TIME: {
                        sdf = new SimpleDateFormat("HH:mm:ss");
                        break;
                    }
                    default: {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    }
                }
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    obj = sdf.format(date);
                    break;
                }
                if (cell.getCellStyle().getDataFormat() == number58) {
                    double value = cell.getNumericCellValue();
                    Date date = DateUtil.getJavaDate((double)value);
                    obj = sdf.format(date);
                    break;
                }
                double dValue = cell.getNumericCellValue();
                Double obj2 = dValue;
                return obj2;
            }
            default: {
                obj = cell.getStringCellValue();
            }
        }
        if (null == metaCellType) {
            return obj;
        }
        switch (metaCellType) {
            case STRING: {
                return null == obj ? "" : obj.toString();
            }
        }
        return obj;
    }

    public static Object parseCell(Cell cell, CellType metaDataType) {
        Object obj;
        CellType cellType = cell.getCellTypeEnum();
        switch (cellType) {
            case FORMULA: {
                try {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        obj = date.getYear() + 1900 + "-" + (date.getMonth() + 1) + "-" + date.getDate();
                        break;
                    }
                    obj = String.valueOf(cell.getNumericCellValue());
                }
                catch (IllegalStateException e) {
                    obj = String.valueOf(cell.getRichStringCellValue());
                }
                break;
            }
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case NUMERIC: {
                short number58 = 58;
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date = cell.getDateCellValue();
                    obj = sdf.format(date);
                    break;
                }
                if (cell.getCellStyle().getDataFormat() == number58) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    double value = cell.getNumericCellValue();
                    Date date = DateUtil.getJavaDate((double)value);
                    obj = sdf.format(date);
                    break;
                }
                double value = cell.getNumericCellValue();
                obj = value;
                break;
            }
            default: {
                obj = cell.getStringCellValue();
            }
        }
        if (null == metaDataType) {
            return obj;
        }
        switch (metaDataType) {
            case STRING: {
                return null == obj ? "" : obj.toString();
            }
        }
        return obj;
    }

    protected static Object parseCell(Cell cell) {
        return ExcelUtil.parseCell(cell, null);
    }

    private static void realeaseResources(ExcelParserBean parserBean, Workbook workbook) {
        try {
            InputStream inputStream = parserBean.getInput();
            if (inputStream != null) {
                inputStream.close();
            }
            if (workbook != null) {
                workbook.close();
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
    }

    private static String getFileExtension(String filePath) {
        if (StringUtils.isEmpty((String)filePath)) {
            return null;
        }
        int lastIndexOf = filePath.lastIndexOf(".");
        if (lastIndexOf != -1) {
            String extension = filePath.substring(lastIndexOf + 1);
            return extension;
        }
        return null;
    }

    public static String getSheetNameInParens(String sheetName) {
        String regex = "[\\(\uff08](.*?)[\\)\uff09]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(sheetName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return sheetName;
    }
}

