package com.digiwin.athena.base.infrastructure.meta.po.trial;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/08/30 13:39:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "trial_apply_info")
public class TrialApplyData extends BaseEntity<TrialApplyData> implements Serializable {
    /**
     * 主键ID
     */
    @TableId()
    private Long id;
    /**
     * 公司或者组织名称
     */
    private String company;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 手机号码
     */
    private String phone;

    /**
     * 电子邮箱
     */
    private String email;
    /**
     * 问卷内容，json串
     */
    private String faq;

    /**
     * 提交申请的使用信息列表
     */
    private String productInfo;

    /**
     * 邮件接收者信息
     */
    private String recInfo;
}
