/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.importstatistics.util.excel;

import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import lombok.Generated;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelHellper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelHellper.class);

    public static void addComment(Cell cell, String value, String extension) {
        Sheet sheet = cell.getSheet();
        cell.removeCellComment();
        if (".xls".equals(extension)) {
            HSSFClientAnchor anchor = new HSSFClientAnchor();
            anchor.setDx1(0);
            anchor.setDx2(0);
            anchor.setDy1(0);
            anchor.setDy2(0);
            anchor.setCol1(cell.getColumnIndex());
            anchor.setRow1(cell.getRowIndex());
            anchor.setCol2(cell.getColumnIndex() + 5);
            anchor.setRow2(cell.getRowIndex() + 6);
            Drawing drawing = sheet.createDrawingPatriarch();
            Comment comment = drawing.createCellComment((ClientAnchor)anchor);
            comment.setString((RichTextString)new HSSFRichTextString(value));
            cell.setCellComment(comment);
        } else if (".xlsx".equals(extension)) {
            XSSFClientAnchor anchor = new XSSFClientAnchor();
            anchor.setDx1(0);
            anchor.setDx2(0);
            anchor.setDy1(0);
            anchor.setDy2(0);
            anchor.setCol1(cell.getColumnIndex());
            anchor.setRow1(cell.getRowIndex());
            anchor.setCol2(cell.getColumnIndex() + 5);
            anchor.setRow2(cell.getRowIndex() + 6);
            Drawing drawing = sheet.createDrawingPatriarch();
            Comment comment = drawing.createCellComment((ClientAnchor)anchor);
            comment.setString((RichTextString)new XSSFRichTextString(value));
            cell.setCellComment(comment);
        }
    }

    public String getCellFromExcel(String path, String row, String col) throws Exception {
        return this.getCellFromExcel(path, 0, Integer.valueOf(row), Integer.valueOf(col));
    }

    public String getRowFromExcel(String path, String row) throws Exception {
        return this.getRowFromExcel(path, 0, Integer.valueOf(row));
    }

    public String getRowFromExcel(String path, int sheet, int row) throws Exception {
        File xlsx = new File(path);
        Workbook workbook = WorkbookFactory.create((File)xlsx);
        Sheet sheet1 = workbook.getSheetAt(sheet);
        Row row1 = sheet1.getRow(row);
        ArrayList<String> list = new ArrayList<String>();
        int rowNum = row1.getLastCellNum();
        for (int i = 0; i < rowNum; ++i) {
            list.add(ExcelHellper.getCellValueByCell(row1.getCell(i)));
        }
        log.info("\u6587\u4ef6\u540d\uff1a{}\uff0csheet\uff1a{}\uff0crow\uff1a{}\uff0c\u53d6\u503c\uff1a{}", new Object[]{path, sheet, row, ((Object)list).toString()});
        return ((Object)list).toString();
    }

    public String getCellFromExcel(String path, int sheet, int row, int col) throws Exception {
        File xlsx = new File(path);
        Workbook workbook = WorkbookFactory.create((File)xlsx);
        Sheet sheet1 = workbook.getSheetAt(sheet);
        Row row1 = sheet1.getRow(row);
        String cell = ExcelHellper.getCellValueByCell(row1.getCell(col));
        log.info("\u6587\u4ef6\u540d\uff1a{}\uff0csheet\uff1a{}\uff0crow\uff1a{}\uff0ccol\uff1a{}\uff0c\u53d6\u503c\uff1a{}", new Object[]{path, sheet, row, col, cell});
        return cell;
    }

    private static String getCellValueByCell(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String cellValue = "";
        int cellType = cell.getCellType();
        switch (cellType) {
            case 0: {
                if (0 != cell.getCellType()) break;
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    cellValue = formater.format(date);
                    break;
                }
                cellValue = cell.getNumericCellValue() + "";
                break;
            }
            case 1: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case 4: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            case 2: {
                cellValue = cell.getCellFormula() + "";
                break;
            }
            case 3: {
                cellValue = "";
                break;
            }
            case 5: {
                cellValue = MessageUtil.getMessage((String)"delivery.invalidStr", (Object[])new Object[0]);
                break;
            }
            default: {
                cellValue = MessageUtil.getMessage((String)"delivery.unknowType", (Object[])new Object[0]);
            }
        }
        return cellValue;
    }
}

