/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.importstatistics.kg;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.common.api.DapResponse;
import com.digiwin.athena.atdm.importstatistics.dto.ApplicationRelationQueryDTO;
import com.digiwin.athena.atdm.importstatistics.util.Utils;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class DataEntryKgService {
    private static final Logger log = LoggerFactory.getLogger(DataEntryKgService.class);
    @Value(value="${themeMap.uri}")
    private String knowledgeGraphUrl;
    private final String APPLICATION_NAMEANDTAG_CONFIG = "knowledgegraph/app/byNameAndTags";
    private final String QUERY_DIGITALSTAFF = "knowledgegraph/app/queryDigitalStaffByCode";
    private final String GET_ENHANCE_BYAPPCODE = "knowledgegraph/app/enhanceByAppCode";
    private final String BY_CODES_AND_TYPE = "knowledgegraph/app/ApplicationRelationsByCodesAndType";
    private final String APPLICATION_BY_TYPE_AND_CODE = "knowledgegraph/app/ApplicationByTypeAndCode";
    private String kghost = null;

    public DapResponse getApplicationByNameAndTags(String applicationName, List<String> tags) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (applicationName != null && !applicationName.isEmpty()) {
            params.put("applicationName", applicationName);
        } else {
            params.put("applicationName", "");
        }
        if (tags != null && !tags.isEmpty()) {
            params.put("tags", tags);
        } else {
            params.put("tags", new ArrayList<String>(){});
        }
        DapResponse response = this.requestKg("knowledgegraph/app/byNameAndTags", "get", params);
        return response;
    }

    public DapResponse requestKg(String service, String httpMethod, Map<String, Object> params) {
        String url = this.knowledgeGraphUrl + service;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("designer", "deliveryDesigner");
        if (null == this.kghost) {
            try {
                URL u = new URL(this.knowledgeGraphUrl);
                this.kghost = u.getHost();
            }
            catch (MalformedURLException e) {
                log.error(e.toString());
            }
        }
        headers.put("Host", this.kghost);
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        if (null != user) {
            headers.put("token", user.getToken());
            headers.put("routerKey", user.getTenantId());
            headers.put("locale", LocaleContextHolder.getLocale().toString());
        }
        DapResponse result = null;
        result = "post".equalsIgnoreCase(httpMethod) ? Utils.postJson(url, headers, params, DapResponse.class) : ("delete".equalsIgnoreCase(httpMethod) ? Utils.deleteJson(url, headers, params, DapResponse.class) : Utils.get(url, headers, params, DapResponse.class));
        return result;
    }

    public DapResponse getDigitalStaff(Set<String> codeList, Set<String> enhanceCodeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0088.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.codeListEmpty", (Object[])new Object[0]));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("codeList", codeList);
        params.put("enhanceCodeList", enhanceCodeList);
        DapResponse response = this.requestKg("knowledgegraph/app/queryDigitalStaffByCode", "post", params);
        return response;
    }

    public DapResponse getEnhancebyAppCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0089.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.delivery.codeEmpty", (Object[])new Object[0]));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        DapResponse response = this.requestKg("knowledgegraph/app/enhanceByAppCode", "get", params);
        return response;
    }

    public DapResponse postApplicationRelationsByCodesAndType(List<String> code, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ApplicationRelationQueryDTO applicationRelationQueryDTO = new ApplicationRelationQueryDTO();
        applicationRelationQueryDTO.setCodes(code);
        applicationRelationQueryDTO.setType(type);
        params.put("applicationRelationQueryDTO", applicationRelationQueryDTO);
        DapResponse response = this.requestKg("knowledgegraph/app/ApplicationRelationsByCodesAndType", "post", params);
        return response;
    }

    public DapResponse getApplicationByTypeAndCode(String type, String code) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("code", code);
        DapResponse response = this.requestKg("knowledgegraph/app/ApplicationByTypeAndCode", "get", params);
        return response;
    }
}

