package com.digiwin.athena.atdm.importstatistics.application;

import lombok.Data;
import org.springframework.data.annotation.Transient;

import java.util.List;
import java.util.Map;

/**
 * @program: athena
 * @description: 描述
 * @author: Tuo
 * @create: 2021-02-04 11:28
 **/
@Data
public class FieldDescription extends LanguageEntity implements Comparable<FieldDescription> {

    //字段名称
    private String name;
    //字段的key
    private String key;
    //字段值
    private Object value;
    //数据类型 BOOLEAN,INTEGER,LONG,DOUBLE,STRING,DATE,ARRAY,OBJECT
    private String dataType;
    //当type为array时表示内部类型,参见dataType
    private String componentType;
    private String format;//"yyyyMM,yyyyMM"
    //表达式或者路径
    private Object express;
    //当dataType=object时
    private List<FieldDescription> fields;
    //参数描述说明
    private String description;

    //参数默认值
    private Object defaultValue;
    //参数控件类型 PERCENT百分比控件
    private String displayType;
    //参数控件类型的详细定义
    private Object displayTypeDefinition;
    //参数控件显示格式
    private String displayFormat;//"yyyy-MM"
    //对应value的外显 可能是数组 [{"value":"true","label":"Y"},{"value":"false","label":"N"}]
    private Object valueDisplay;
    // 对应select的枚举值 可能是数组 [{"value":"true","label":"Y"},{"value":"false","label":"N"}]
    private Object options;
    //参数显示顺序
    private int sequence;
    //是否必填
    private boolean required;
    //是否只读
    private boolean readOnly;
    //参数校验
    private String validateScript;

    //控制参数是否可见 范围 ["param1","param2","param3"]
    private List<String> paramVisbleScope;
    //控制参数是否可见的键值匹配 {"true":"param1,param2","false":"param2,param3"}
    private Map paramVisble;
    //是否为执行参数
    private Boolean isExecute;
    //是否为模拟参数
    private Boolean isSimulation;
    //是否存在上一次记录  现在后端不用传这个值的属性，由前端自己获取
    private Boolean existLastRecord;
    //作为执行参数时的显示名称
    private String executeName;

    private int colspan;
    //参数的扩展数据 displayType为MONTH_PERIODIC时保存侦测规则id
    private String extendData;
    //参数类型 侦测周期period 变量variable 敏态参数
    private String category;
    //参数来源 espapi 表示参数来源于调用esp接口
    private String from = "default";
    //是否为运营单元参数
    private Boolean isOperation;
    //运营单元层级
    private Map eocLevel;

    //是否允许(立即)执行
    private Integer executable;
    //周期开关 分号分隔 M;W;D;H;F M每x月 W每x周 D每x天 H每x小时 F每x分钟
    private String periodEnable;
    //侦测动态条件下拉
    private Object fieldMappings;
    //侦测动态条件
    private Object dynamicCondition;

    //分组 同一组参数被归在一起 例如 控制能力 限制能力 决策能力 驱动能力
    private String group;

    //参数所属机制code
    private String mechanismCode;

    //增强应用
    private String enhance;

    // 是否显示参数的条件对象
    private DynamicCondition visibleCondition;
    // 动态条件开窗：条件列字段与开窗key对应关系
    private List<FieldOpenWindowSetting> fieldOpenWindowMap;
    // 动态条件对应开窗信息
    @Transient
    private Map<String, OpenWindowDefinition> fieldOpenWindowDefinitions;

    private Boolean forceOpen;

    //当displayType为NUMBER时 控制输入的最大 最小 和 步进值
    private Integer max;
    private Integer min;
    private Integer step;
    //弹窗 modal 或跳转 blank
    private String target;

    private Object presetVariables;
    //绑定哪个按钮的key 子联动控件的key
    private List<String> linkKey;
    //子联动控件的数据源
    private Object linkOptions;

    // 存放Group类型的子组件
    private Object parameters;

    // Number类型的精度
    private String precision;

    @Override
    public int compareTo(FieldDescription o) {
        return this.sequence - o.getSequence();
    }
}
