package com.digiwin.athena.atdm.importstatistics.util;


import cn.hutool.core.util.NumberUtil;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class LanguageUtil {

    public static void processLocaleLanguage(Object data, String locale) throws IllegalAccessException, NoSuchFieldException {
        if (data == null) {
            return;
        }

        Map<String, Map<String, String>> language = null;
        if (data instanceof Map) {
//            language = (Map<String, Map<String, String>>)((Map)data).get("lang");
//            if (language == null || language.isEmpty()) {
//                return;
//            }
            for (Map.Entry<String, Object> entry : ((Map<String, Object>)data).entrySet()) {
                if (entry.getKey().equals("lang")) {
                    continue;
                }

                if(entry.getValue() == null){
                    continue;
                }
                if (isPrimitive(entry.getValue().getClass())) {
                    continue;
                }

                if (isNumber(String.valueOf(entry.getValue()))) {
                    continue;
                }

                if(entry.getValue() instanceof String){
                    language = (Map<String, Map<String, String>>)((Map)data).get("lang");
                    if (language == null || language.isEmpty()) {
                        continue;
                    }
                    if (language.containsKey(entry.getKey())) {
                        Map<String, String> lang = language.get(entry.getKey());
                        if (lang.containsKey(locale)) {
                            entry.setValue(lang.get(locale));
                        }
                    }
                }else{
                    processLocaleLanguage(entry.getValue(), locale);
                }
//                if (language.containsKey(entry.getKey())) {
//                    Map<String, String> lang = language.get(entry.getKey());
//                    if (lang.containsKey(locale)) {
//                        entry.setValue(lang.get(locale));
//                    }
//                }
            }
        } else if (data instanceof List) {
            for (Object item : (List) data) {
                processLocaleLanguage(item, locale);
            }
        }
        else {

            if(data == null){
                return;
            }

            if (isPrimitive(data.getClass())) {
                return;
            }

            if (isNumber(String.valueOf(data))) {
                return;
            }
            Field langField = null;
            try {
                langField = data.getClass().getField("lang");
                language = (Map<String, Map<String, String>>)langField.get(data);
            } catch (NoSuchFieldException ex) {}

            Class<?> clazz = data.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                if (field.isSynthetic()) {//跳过由编译器生成的字段 例如$jacocoData
                    continue;
                }

                if (isPrimitive(field.getType())) {
                    continue;
                }

                if (field.getType().equals(String.class)) {
                    String fieldName = field.getName();
                    if (language != null && !language.isEmpty() && language.containsKey(fieldName)) {
                        Map<String, String> lang = language.get(fieldName);
                        if (lang.containsKey(locale)) {//未判断存在语言别定义但为null的情况 ex zh_TW:null
                            field.set(data, lang.get(locale));
                        }
                    }
                } else if (field.get(data) instanceof String) {
                    String fieldName = field.getName();
                    if (language != null && !language.isEmpty() && language.containsKey(fieldName)) {
                        Map<String, String> lang = language.get(fieldName);
                        if (lang.containsKey(locale)) {//未判断存在语言别定义但为null的情况 ex zh_TW:null
                            field.set(data, lang.get(locale));
                        }
                    }
                }
                else if (field.get(data) instanceof List) {
                    for (Object item : (List) field.get(data)) {
                        processLocaleLanguage(item, locale);
                    }
                } else if (field.get(data) instanceof Object) {
                    processLocaleLanguage(field.get(data), locale);
                }else if (field.getType().equals(Object.class)) {
                    processLocaleLanguage(field.get(data), locale);
                }
            }
        }
    }

    public static boolean isPrimitive(Class clz) {

        try {
            if(clz.isPrimitive()){
                return true;
            }
            return ((Class) clz.getField("TYPE").get(null)).isPrimitive();

        } catch (Exception e) {

            return false;

        }

    }

    private static boolean isNumber(String str){
        return NumberUtil.isNumber(str);
    }

}