package com.digiwin.athena.base.infrastructure.manager.aim;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.base.infrastructure.config.EnvProperties;
import com.digiwin.athena.base.infrastructure.manager.aim.model.MessageBatchUserDTO;
import com.digiwin.athena.base.infrastructure.manager.aim.model.MessageDO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;
@Slf4j
@Service
public class BaseAimServiceImpl implements BaseAimService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    /**
     * 发送消息给在线客户端
     */
    public static final String SEND_MESSAGE_TO_CLIENT = "/api/aim/v2/send/message/to/client";



    /**
     * @param message 内容
     */
    @Override
    public void sendMessageToClient(String token, String tenantId, List<String> userIdList, MessageDO message) {
        log.info("sendMessageToClient message:{}", message);
        LogDto logDto = new LogDto("请求aim发送新消息开始，userIds：" + userIdList, tenantId + userIdList.toString());
        log.info(logDto.toString());
        MessageBatchUserDTO messageBatchUserDTO = new MessageBatchUserDTO();
        messageBatchUserDTO.setMessage(message);
        messageBatchUserDTO.setUserIdList(userIdList);
        messageBatchUserDTO.setTenantId(tenantId);
        String url = envProperties.getAimUri() + SEND_MESSAGE_TO_CLIENT;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);

        HttpEntity httpEntity = new HttpEntity(messageBatchUserDTO, headers);
        ResponseEntity<BaseResultDTO> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO>() {
                });
        log.info("sendMessageToClient respEntity:{}", respEntity.getBody().getStatusDescription());
        respEntity.getBody().getResponseWithException("");
    }
}
