package com.digiwin.athena.base.infrastructure.meta.po.commonused;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "common_category")
public class CategoryData extends BaseEntity<CategoryData> implements Serializable {
    @TableId()
    private Long id;

    private String cateName;

    private Long parentId;
    private String userId;
    private String userName;
    private String modifyUserId;
    private String modifyUserName;
    private Integer plat;
    private Integer isShow;
    @TableField("`rank`")
    private Integer rank;
    private String tenantId;
    private Integer isTop;
    /**
     * 分组是折叠还是展开 0:折叠 1：展开
     */
    private Integer unfold;

}
