package com.digiwin.athena.base.infrastructure.meta.po.trial;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/09/28 09:36:54
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "scene_card")
public class SceneCardData extends BaseEntity<SceneCardData> implements Serializable {
    @TableId()
    private Long id;

    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 任务卡项目卡id
     */
    private String cardId;
    /**
     * 场景id
     */
    private Long sceneId;
    /**
     * 步骤id
     */
    private Long stepId;
    /**
     * 类型 1：项目卡 2：任务卡
     */
    private Integer type;
}

