package com.digiwin.athena.base.infrastructure.meta.po.trial;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/09/03 16:38:55
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "trial_scene")
public class TrialSceneData extends BaseEntity<TrialSceneData> implements Serializable {
    @TableId()
    private Long id;

    /**
     * 场景关键字
     */
    private String sceneKey;

    /**
     * 场景描述
     */
    private String sceneDesc;

    /**
     * 场景详情
     */
    private String detail;
}
