package com.digiwin.athena.base.infrastructure.manager.emc;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service
public class BaseSendEmailServiceImpl implements BaseSendEmailService {
    private static final String SEND_EMAIL_URL = "/api/emc/v1/message/email";

    @Value("${emc.uri:}")
    private String emcUri;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void sendEmail(JSONObject content) {
        log.info("[SendEmail] SendEmailService start: {}", content);

        String url = emcUri + SEND_EMAIL_URL;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<?> httpEntity = new HttpEntity<>(content, headers);

        ResponseEntity<HashMap> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, HashMap.class);
        Object code = respEntity.getBody().get("code");
        Object success = respEntity.getBody().get("success");
        try {
            if (!requestSuccess(code, success)) {
                String errorMessage = messageUtils.getMessage("emc.v1.message.email");
                log.error("{}, 发送邮件失败，{}, {}", AudcErrorCodeEnum.EMC_V1_MESSAGE_EMAIL.getErrCode(), errorMessage, "status code: " + HttpStatus.SC_OK + ", code: " + String.valueOf(code) + ", message: " + String.valueOf(respEntity.getBody().get("message")));
                throw BusinessException.create(AudcErrorCodeEnum.EMC_V1_MESSAGE_EMAIL.getErrCode(), errorMessage);
            }
        } catch (Exception ex) {
            throw ExceptionUtil.wrap(AudcErrorCodeEnum.EMC_V1_MESSAGE_EMAIL.getErrCode(), ex);
        }
    }

    @Override
    public void sendEmailWithTemplate(String templateId, String receiver, Map<String, Object> emailData) {
        JSONObject emailJson = new JSONObject();
        emailJson.put("eventId", templateId);

        JSONObject emailMsg = new JSONObject();
        emailMsg.put("data", emailData);
        emailJson.put("message", emailMsg);
        emailJson.put("contacts", receiver);

        sendEmail(emailJson);
    }

    private boolean requestSuccess(Object code, Object success) {
        if (null == code || null == success) {
            return false;
        }
        return StringUtils.equals(String.valueOf(code), String.valueOf(HttpStatus.SC_OK)) && Boolean.valueOf(String.valueOf(success));
    }
}
