package com.digiwin.athena.base.infrastructure.manager.iam.service;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.infrastructure.manager.iam.model.AppAuthoredDTO;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.util.List;
import java.util.Map;

/**
 * IamService Description
 *
 * @author majianfu
 * @date 2021/9/1
 * @since
 */
public interface BaseIamService {
    String USER_PERMISSION_TARGET_PREFIX = "drn:iam:app:";

    /**
     * 从鼎捷云获取租户 + 用户 权限配置
     *
     * @param authoredUser
     * @param appCode
     * @return
     */
    JSONObject getAllUserPermissionV2(AuthoredUser authoredUser, String appCode);

    /**
     * 所有用户被授权的应用列表
     *
     * @param token
     */
    List<AppAuthoredDTO> getUserAuthoredApp(String token);

    /**
     * 批量查询用户应用权限配置
     *
     * @param authoredUser
     * @param authoredAppCodeList
     * @return
     */
    JSONArray batchQueryUserAppPermission(AuthoredUser authoredUser, List<String> authoredAppCodeList);

    /**
     * @description: 根据邮箱、号码获取个人租户
     * @param authoredUser, email, telephone, appId, tenantType
     * @return 
     * @author: sunyfa
     */
    Map<String,Object> getTenantAuth(AuthoredUser authoredUser, String email, String telephone, String appId,
                                     Integer tenantType);

    /**
     * @description: 创建个人租户以及授权
     * @param
     * @return
     * @author: sunyfa
     */
    Map<String, String> registerTenant (AuthoredUser authoredUser, String email, String telephone, String appId,
                                        String strategySid, String strategyCode);

    /**
     * @description: 给指定租户下的用户授权指定应用
     * @param
     * @return
     * @author: sunyfa
     */
    Boolean authorizeUser(AuthoredUser authoredUser,String tenantId, String email, String telephone,
                          String appId, String strategySid, String strategyCode,Boolean isTenantAuth);

    /**
     * 查询批量用户的单项元数据设置
     *
     * @param userIdList
     * @param tenantSid
     * @param key
     * @param catalogId
     * @return
     */
    List<Map> batchQueryUserMetadataItem(List<String> userIdList, String tenantSid, String key, String catalogId);

    /**
     * 查询用户类型
     *
     * @param userId
     * @param token
     * @return 0：内部用户；1：外部用户
     */
    Integer queryUserType(String userId, String token);
}
