package com.digiwin.athena.base.infrastructure.manager.uibot;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;

@Service
public class BaseReportServiceImpl implements BaseReportService {
    @Value("${idrive-business-report.uri:}")
    private String idriveBusinessReportUri;

    @Resource
    private RestTemplate restTemplate;

    public static final String IS_SYS_ROLE = "/api/v1/afc/report/query/isSysRole";

    @Override
    public Boolean isSysRole(AuthoredUser user) {
        String url = idriveBusinessReportUri + IS_SYS_ROLE;

        ResponseEntity<BaseResultDTO<Boolean>> respEntity = restTemplate.exchange(url, HttpMethod.GET, null, new ParameterizedTypeReference<BaseResultDTO<Boolean>>() {
        });
        return respEntity.getBody().getResponseWithException("");
    }
}
