/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.manager.semc.service;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.base.infrastructure.manager.semc.res.TenantModuleRes;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SemcReqService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SemcReqService.class);
    @Value(value="${semc.uri:}")
    private String semcUrl;
    @Resource
    private RestTemplate restTemplate;

    public List<TenantModuleRes> findTenantModuleList(String moduleCode) {
        if (StringUtils.isNotBlank((CharSequence)moduleCode)) {
            try {
                ResponseEntity responseEntity = this.restTemplate.exchange(this.semcUrl + "/semc/moduleOrder/queryTenant?moduleCode=" + moduleCode, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TenantModuleRes>>>(){}, new Object[0]);
                return (List)((BaseResultDTO)responseEntity.getBody()).getResponse();
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u9519\u8bef,\u6a21\u5757:{},\u9519\u8bef\u4fe1\u606f:{}", new Object[]{moduleCode, e.getMessage(), e});
            }
        }
        return Collections.emptyList();
    }
}

