package com.digiwin.athena.base.infrastructure.manager.abt;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atdm.importstatistics.dto.ActivityStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.BatchImportListRespDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadBaseDataParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadExportFileParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadHistoryProjectTaskParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadTemplateDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ErrorTableDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ExportBasicDataRespDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ExportHeaderRespDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ExportStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ImportStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.UploadParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.UserStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.GetRecordsParamDTO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 对接Abt服务
 *
 * @author lisheng
 * @since [2023S15]
 */
public interface AbtService {

    void handleUpload(UploadParamDTO uploadParam, MultipartFile file);

    void republish(UploadParamDTO uploadParamDTO);

    ImportStatisticsDTO queryImportStatistics(String masterId);

    ErrorTableDTO getErrorTable(String masterId, String locale);

    byte[] downloadTemplate(String actionId, String token, String locale, DownloadTemplateDTO downloadTemplateDTO);

    byte[] downloadBaseData(DownloadBaseDataParamDTO downloadBaseDataParamDTO);

    ActivityStatisticsDTO getActivityStatistics(String activityCode, String userId);

    UserStatisticsDTO getProcessingNum(String userId, String tenantId);

    List<ImportStatisticsDTO> getRecords(AuthoredUser user, String locale, Integer getRecordsNum, String activityName, String startTime, String endTime, String type, Integer state, Integer offset);

    List<ExportStatisticsDTO> getExportRecords(AuthoredUser user, String locale, GetRecordsParamDTO getRecordsParamDTO);

    UserStatisticsDTO getExportingNum(String userId, String tenantId, String type, List<String> types);

    Boolean startDownload(DownloadBaseDataParamDTO downloadBaseDataParamDTO);

    ExportStatisticsDTO queryExportStatistics(DownloadExportFileParamDTO downloadExportFileParamDTO);

    void updateRetryDownloadState(String masterId);

    ExportHeaderRespDTO getTableHeader(String actionId);


    void uploadAsync(List<UploadParamDTO> uploadParamDTO);


    List<BatchImportListRespDTO> getImportBasicDataList();

    List<ExportBasicDataRespDTO> getExportBasicDataList();

    Boolean startDownloadHistoryData(DownloadHistoryProjectTaskParamDTO downloadHistoryProjectTaskParamDTO);
}
