package com.digiwin.athena.base.infrastructure.manager.atmc;

import com.digiwin.athena.base.infrastructure.manager.atmc.dto.NoticeProxyInfoDTO;
import com.digiwin.athena.base.infrastructure.manager.atmc.dto.VerifyAppPermissionReq;
import com.digiwin.athena.base.infrastructure.manager.atmc.dto.VerifyAppPermissionDTO;
import net.sf.json.JSONArray;

import java.util.List;
import java.util.Map;

/**
 * AtmcService Description
 *
 * @author majianfu
 * @date 2021/8/28
 * @since
 */
public interface BaseAtmcService {
    List<VerifyAppPermissionDTO>  verifyAppPermission(VerifyAppPermissionReq verifyAppPermissionReq);

    Boolean verifyConfig(String configName,String name);

    JSONArray getGroupDimension();

    /**
     * 发送工作提醒(保存代理信息)
     * @param param
     * @param token
     */
    void messageAgentChange(Map<String, Object> param, String token);

    /**
     * 发送工作提醒(清除代理信息)
     *
     * @param userId
     * @param token
     */
    void messageAgentClear(String userId, String token);

    /**
     * 批量发送工作提醒
     * @param list
     * @param token
     */
    void messageAgentBatchChange(List<NoticeProxyInfoDTO> list, String token);
}
