package com.digiwin.athena.base.infrastructure.manager.semc.service;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.base.infrastructure.manager.semc.res.TenantModuleRes;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;

@Service
@Slf4j
public class SemcReqService {
    @Value("${semc.uri:}")
    private String semcUrl;
    @Resource
    private RestTemplate restTemplate;


    public List<TenantModuleRes> findTenantModuleList(String moduleCode){
        if(StringUtils.isNotBlank(moduleCode)){
            try {
                ResponseEntity<BaseResultDTO<List<TenantModuleRes>>> responseEntity = restTemplate.exchange(semcUrl + "/semc/moduleOrder/queryTenant?moduleCode=" + moduleCode, HttpMethod.GET, null, new ParameterizedTypeReference<BaseResultDTO<List<TenantModuleRes>>>() {
                });
                return  responseEntity.getBody().getResponse();
            }catch (Exception e){
                log.error("获取租户信息错误,模块:{},错误信息:{}",moduleCode,e.getMessage(),e);
            }
        }
        return Collections.emptyList();
    }



}
