/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.importstatistics.util;

import java.util.BitSet;
import org.springframework.stereotype.Component;

@Component
public class BloomFilter {
    private static final int DEFAULT_SIZE = 0x2000000;
    private static final int[] SEEDS = new int[]{3, 5, 7, 11, 13, 31, 37, 61};
    private BitSet bitSet = new BitSet(0x2000000);

    private int getHash(int seed, String value) {
        int result = 0;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            result = seed * result + value.charAt(i);
        }
        return 0x1FFFFFF & result;
    }

    public void add(String value) {
        for (int seed : SEEDS) {
            int hash = this.getHash(seed, value);
            this.bitSet.set(hash, true);
        }
    }

    public boolean contains(String value) {
        if (value == null) {
            return false;
        }
        for (int seed : SEEDS) {
            int hash = this.getHash(seed, value);
            if (this.bitSet.get(hash)) continue;
            return false;
        }
        return true;
    }
}

