/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.manager.atmc;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.manager.atmc.BaseAtmcService;
import com.digiwin.athena.base.infrastructure.manager.atmc.dto.NoticeProxyInfoDTO;
import com.digiwin.athena.base.infrastructure.manager.atmc.dto.VerifyAppPermissionDTO;
import com.digiwin.athena.base.infrastructure.manager.atmc.dto.VerifyAppPermissionReq;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class BaseAtmcServiceImpl
implements BaseAtmcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAtmcServiceImpl.class);
    private static final String VERIFY_APP_PERMISSION = "/api/atmc/v1/permission/external/verifyAppPermission";
    public static final String CONFIG = "api/atmc/v1/config/operationConfig";
    public static final String GROUP_DIMENSION = "/api/atmc/v1/backlog/group/dimension";
    public static final String IS_TEST_TENANT = "/api/atmc/v1/tenant/isTest";
    public static final String MESSAGE_AGENT_CHANGE = "/api/atmc/v1/message/agent/change";
    public static final String MESSAGE_AGENT_CHANGE_BATCH = "/api/atmc/v1/proxy/notice/sendMessage";
    public static final String MESSAGE_AGENT_CLEAR = "/api/atmc/v1/message/agent/clear";
    @Resource
    private RestTemplate restTemplate;
    @Value(value="${atmc.uri:}")
    private String atmcUri;

    @Override
    public List<VerifyAppPermissionDTO> verifyAppPermission(VerifyAppPermissionReq verifyAppPermissionReq) {
        String url = this.atmcUri + VERIFY_APP_PERMISSION;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)BeanUtil.beanToMap((Object)verifyAppPermissionReq, (String[])new String[0]), (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<VerifyAppPermissionDTO>>>(){}, new Object[0]);
        return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public Boolean verifyConfig(String configName, String name) {
        String url = this.atmcUri + CONFIG;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("configName", configName);
        params.put("operation", 0);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)BeanUtil.beanToMap(params, (String[])new String[0]), (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, new Object[0]);
        return (Boolean)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public JSONArray getGroupDimension() {
        String url = this.atmcUri + GROUP_DIMENSION;
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        log.info("[recommend-{}-{}][{} Recommend] invoke ATMC to get project list, url = {}", new Object[]{authoredUser.getUserId(), authoredUser.getTenantId(), "PROJECT", url});
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<JSONArray>>(){}, new Object[0]);
        log.info("[recommend-{}-{}][{} Recommend] invoke ATMC to get project list, status={}, body = {}", new Object[]{authoredUser.getUserId(), authoredUser.getTenantId(), "PROJECT", respEntity.getStatusCodeValue(), JsonUtils.objectToString((Object)respEntity.getBody())});
        return (JSONArray)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public void messageAgentChange(Map<String, Object> param, String token) {
        String url = this.atmcUri + MESSAGE_AGENT_CHANGE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        try {
            log.info("/api/atmc/v1/message/agent/changerequest param", (Object)JsonUtils.objectToString(param));
            HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            log.info("/api/atmc/v1/message/agent/changeresponse", (Object)JsonUtils.objectToString((Object)responseEntity));
            if (Objects.isNull(responseEntity) || Objects.isNull(responseEntity.getBody()) || !StringUtils.equals((CharSequence)String.valueOf(((BaseResultDTO)responseEntity.getBody()).getStatus()), (CharSequence)String.valueOf(200))) {
                throw BusinessException.create((String)AudcErrorCodeEnum.ATMC_V1_MESSAGE_AGENT_CHANGE.getErrCode(), (String)"request atmc changeAgentSetting error");
            }
        }
        catch (Exception ex) {
            log.error("request atmc changeAgentSetting error", (Throwable)ex);
        }
    }

    @Override
    public void messageAgentClear(String userId, String token) {
        String url = this.atmcUri + MESSAGE_AGENT_CLEAR;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        try {
            log.info("/api/atmc/v1/message/agent/clearrequest param", (Object)JsonUtils.objectToString(param));
            HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            log.info("/api/atmc/v1/message/agent/clearresponse", (Object)JsonUtils.objectToString((Object)responseEntity));
            if (Objects.isNull(responseEntity) || Objects.isNull(responseEntity.getBody()) || !StringUtils.equals((CharSequence)String.valueOf(((BaseResultDTO)responseEntity.getBody()).getStatus()), (CharSequence)String.valueOf(200))) {
                throw BusinessException.create((String)AudcErrorCodeEnum.ATMC_V1_MESSAGE_AGENT_CLEAR.getErrCode(), (String)"request atmc changeAgentSetting error");
            }
        }
        catch (Exception ex) {
            log.error("request atmc clearAgentSetting error", (Throwable)ex);
        }
    }

    @Override
    public void messageAgentBatchChange(List<NoticeProxyInfoDTO> list, String token) {
        String url = this.atmcUri + MESSAGE_AGENT_CHANGE_BATCH;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        try {
            log.info("/api/atmc/v1/proxy/notice/sendMessagerequest param", (Object)JsonUtils.objectToString(list));
            HttpEntity httpEntity = new HttpEntity((Object)JsonUtils.objectToString(list), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            log.info("/api/atmc/v1/proxy/notice/sendMessageresponse", (Object)JsonUtils.objectToString((Object)responseEntity));
            if (Objects.isNull(responseEntity) || Objects.isNull(responseEntity.getBody()) || !StringUtils.equals((CharSequence)String.valueOf(((BaseResultDTO)responseEntity.getBody()).getStatus()), (CharSequence)String.valueOf(200))) {
                throw BusinessException.create((String)AudcErrorCodeEnum.ATMC_V1_MESSAGE_AGENT_CHANGE.getErrCode(), (String)"request atmc changeAgentSetting error");
            }
        }
        catch (Exception ex) {
            log.error("request atmc changeAgentSetting error", (Throwable)ex);
        }
    }
}

