package com.digiwin.athena.base.infrastructure.manager.thememap.dto;

import lombok.Data;

/**
 * @description: thememap 定义的标签
 * @author:
 * @create: 2022-01-05
 **/
@Data
public class ThemeMapTag {

    /**
     * tm-ID
     */
    private Long id;

    /**
     * tm-标签名称 目前分组才用到
     */
    private String name;

    /**
     * tm-编码
     * 当category = APPLICATION时，code为应用的code
     */
    private String code;

    /**
     * 类型
     * BUSINESS
     * GROUP
     * ORDER
     * APPLICATION,当为应用时，code为应用的code
     */
    private String category;

    /**
     * 设计时保存-处理的值
     */
    private String value;

    /**
     * 设计时保存-显示名称
     */
    private String title;

    /**
     * 是否强制显示tag上定义的标题
     */
    private Boolean customTitle;

    /**
     *  ai-编码
     */
    private String uiBotCode;

    /**
     * 是否显示group 下面栏位是否显示标题
     */
    private String groupFieldShowTitle;

}
