package com.digiwin.athena.base.infrastructure.meta.po.userdefined;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.time.LocalDateTime;

/**
 * 用户页面操作记录实体
 */
@Data
@TableName("user_operation_record")
public class UserOperationRecordDTO {

    @TableId()
    private long id;

    /**
     * 用户ID
     */
    @TableField(value = "user_id")
    private String userId;

    /**
     * 用户姓名
     */
    @TableField(value = "user_name")
    private String userName;

    /**
     * 租户
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 页面类型：0.基础资料
     */
    @TableField(value = "page_type")
    private String pageType;

    /**
     * 页面CODE
     */
    @TableField(value = "page_code")
    private String pageCode;

    /**
     * 是否占用0.否1.是
     */
    @TableField(value = "take_up")
    private String takeUp;

    /**
     * 业务主键
     */
    @TableField(value = "business_key")
    private String businessKey;

    /**
     * 页面的唯一标识
     */
    @TableField(value = "client_id")
    private String clientId;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private LocalDateTime updateTime;

    public String getKey(){
        StringBuilder editBuilder = new StringBuilder();
        editBuilder.append(this.tenantId);
        editBuilder.append(this.pageCode);
        editBuilder.append(this.pageType);
        if(StringUtils.isNotEmpty(this.businessKey)){
            editBuilder.append(this.businessKey);
        }
        return editBuilder.toString();
    }

}
