package com.digiwin.athena.base.infrastructure.manager.abt.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.dto.ActivityStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.BatchImportListRespDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadBaseDataParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadExportFileParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadHistoryProjectTaskParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadTemplateDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ErrorTableDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ExportBasicDataRespDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ExportHeaderRespDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ExportStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ImportStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.UploadParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.UserStatisticsDTO;
import com.digiwin.athena.base.infrastructure.config.EnvProperties;
import com.digiwin.athena.base.infrastructure.manager.abt.AbtService;
import com.digiwin.athena.base.infrastructure.manager.abt.model.DownloadTemplateParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.GetActivityStatisticsParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.GetErrorTableParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.GetExportingNumParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.GetProcessingNumParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.GetRecordsParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.QueryExportStatisticsParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.QueryImportStatisticsParamDTO;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Slf4j
@Service
public class AbtServiceImpl implements AbtService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    /**
     * 上传
     */
    public static final String UPLOAD = "/api/abt/v1/baseDataEntry/upload";

    /**
     * 重新导入
     */
    public static final String REPUBLISH = "/api/abt/v1/baseDataEntry/republish";


    /**
     * 重新导入
     */
    public static final String REPUBLISH_ID = "/api/abt/v1/baseDataEntry/republishById";

    /**
     * 开始下载
     */
    public static final String START_DOWNLOAD = "/api/abt/v1/baseDataEntry/startDownload";

    /**
     * 查询导入详情
     */
    public static final String GET_IMPORT_STATISTICS = "/api/abt/v1/baseDataEntry/getImportStatistics";

    /**
     * 查询导出详情
     */
    public static final String QUERY_EXPORT_STATISTICS = "/api/abt/v1/baseDataEntry/queryExportStatistics";

    /**
     * 更新重新导入状态
     */
    public static final String UPDATE_RETRY_DOWNLOAD_STATE = "/api/abt/v1/baseDataEntry/updateRetryDownloadState";

    /**
     * abt异步上传接口
     */
    public static final String UPLOAD_ASYNC = "/api/abt/v1/baseDataEntry/uploadAsync";

    /**
     * abt 导入列表
     */
    public static final String IMPORT_BASIC_DATA_LIST = "/api/abt/v1/baseDataEntry/import/basicDataList";

    /**
     * abt 导出列表
     */
    public static final String EXPORT_BASIC_DATA_LIST = "/api/abt/v1/baseDataEntry/export/basicDataList";

    /**
     * abt 获取表头
     */
    public static final String GET_TABLE_HEADERS = "/api/abt/v1/baseDataEntry/getTableHeaders?actionId=";

    /**
     * 获取导入异常数据
     */
    public static final String GET_ERROR_TABLE = "/api/abt/v1/baseDataEntry/getErrorTable";

    /**
     * 下载导入模板
     */
    public static final String DOWNLOAD_TEMPLATE = "/api/abt/v1/baseDataEntry/downloadTemplate";

    /**
     * 导出基础资料
     */
    public static final String DOWNLOAD_BASE_DATA = "/api/abt/v1/baseDataEntry/downloadBaseData";

    /**
     *
     */
    public static final String GET_ACTIVITY_STATISTICS = "/api/abt/v1/baseDataEntry/getActivityStatistics";

    /**
     * 获取导入处理中的数量
     */
    public static final String GET_PROCESSING_NUM = "/api/abt/v1/baseDataEntry/getProcessingNum";

    /**
     * 查询导入记录
     */
    public static final String GET_RECORDS = "/api/abt/v1/baseDataEntry/getRecords";

    /**
     * 查询导出记录
     */
    public static final String QUERY_EXPORT_RECORDS = "/api/abt/v1/baseDataEntry/queryExportRecords";

    /**
     * 获取导出处理中的数量
     */
    public static final String GET_EXPORTING_NUM = "/api/abt/v1/baseDataEntry/getExportingNum";

    /**
     * 开始下载历史项目任务明细
     */
    public static final String START_DOWNLOAD_HISTORY_DATA = "/api/abt/v1/historyProjectTask/startDownloadHistoryData";


    @Override
    public void handleUpload(UploadParamDTO uploadParam, MultipartFile uploadFile) {
        if (Objects.isNull(uploadFile)) {
            log.error("uploadFile is null!");
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0078.getErrCode(), MessageUtil.getMessage("delivery.fileEmpty"));
        }
        String url = envProperties.getAbtUri() + UPLOAD;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);

        HttpHeaders fileHeader = new HttpHeaders();
        fileHeader.setContentType(MediaType.parseMediaType(uploadFile.getContentType()));
        fileHeader.setContentDispositionFormData("file", uploadFile.getOriginalFilename());

        HttpHeaders fileInfoHeader = new HttpHeaders();
        fileInfoHeader.setContentType(MediaType.APPLICATION_JSON);

        MultiValueMap<String, Object> multiValueMap = new LinkedMultiValueMap<>();
        HttpEntity<ByteArrayResource> fileEntity;
        try {
            fileEntity = new HttpEntity<>(new ByteArrayResource(uploadFile.getBytes()), fileHeader);
        } catch (IOException e) {
            log.error("调用上传api失败,e:{}", e);
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0077.getErrCode(), MessageUtil.getMessage("delivery.uploadError2"));
        }

        HttpEntity<UploadParamDTO> uploadParamEntity = new HttpEntity<>(uploadParam, fileInfoHeader);
        multiValueMap.add("uploadParam", uploadParamEntity);
        multiValueMap.add("file", fileEntity);
        HttpEntity<MultiValueMap<String, Object>> httpEntity = new HttpEntity(multiValueMap, headers);
        log.info("handleUpload httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO> respEntity = restTemplate.postForEntity(url, httpEntity, BaseResultDTO.class);
        log.info("handleUpload respEntity:{}", respEntity.getBody().getStatus());
    }

    @Override
    public void republish(UploadParamDTO uploadParamDTO) {
        String url = envProperties.getAbtUri() + REPUBLISH;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(uploadParamDTO, headers);

        log.info("republish httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO>() {
                });
        log.info("republish respEntity:{}", respEntity.getBody().getStatus());
    }

    @Override
    public ImportStatisticsDTO queryImportStatistics(String masterId) {
        String url = envProperties.getAbtUri() + GET_IMPORT_STATISTICS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        QueryImportStatisticsParamDTO queryImportStatisticsParamDTO = new QueryImportStatisticsParamDTO();
        queryImportStatisticsParamDTO.setMasterId(masterId);
        HttpEntity httpEntity = new HttpEntity(queryImportStatisticsParamDTO, headers);

        log.info("queryImportStatistics httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<ImportStatisticsDTO>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<ImportStatisticsDTO>>() {
                });
        log.info("queryImportStatistics respEntity:{}", respEntity.getBody().getResponseWithException(""));
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public ErrorTableDTO getErrorTable(String masterId, String locale) {
        String url = envProperties.getAbtUri() + GET_ERROR_TABLE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        GetErrorTableParamDTO getErrorTableParamDTO = new GetErrorTableParamDTO();
        getErrorTableParamDTO.setMasterId(masterId);
        getErrorTableParamDTO.setLocale(locale);
        HttpEntity httpEntity = new HttpEntity(getErrorTableParamDTO, headers);

        log.info("getErrorTable httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<ErrorTableDTO>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<ErrorTableDTO>>() {
                });
        log.info("getErrorTable respEntity:{}", respEntity.getBody().getStatus());
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public byte[] downloadTemplate(String actionId, String token, String locale, DownloadTemplateDTO downloadTemplateDTO) {
        String url = envProperties.getAbtUri() + DOWNLOAD_TEMPLATE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        DownloadTemplateParamDTO downloadTemplateParamDTO = new DownloadTemplateParamDTO();
        downloadTemplateParamDTO.setActionId(actionId);
        downloadTemplateParamDTO.setToken(token);
        downloadTemplateParamDTO.setLocale(locale);
        downloadTemplateParamDTO.setDownloadTemplateDTO(downloadTemplateDTO);
        HttpEntity httpEntity = new HttpEntity(downloadTemplateParamDTO, headers);

        log.info("downloadTemplate httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<byte[]>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<byte[]>>() {
                });
        log.info("downloadTemplate respEntity:{}", respEntity.getBody().getStatus());
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public byte[] downloadBaseData(DownloadBaseDataParamDTO downloadBaseDataParamDTO) {
        String url = envProperties.getAbtUri() + DOWNLOAD_BASE_DATA;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(downloadBaseDataParamDTO, headers);

        log.info("downloadBaseData httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<byte[]>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<byte[]>>() {
                });
        log.info("downloadBaseData respEntity:{}", respEntity.getBody().getStatus());
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public ActivityStatisticsDTO getActivityStatistics(String activityCode, String userId) {
        String url = envProperties.getAbtUri() + GET_ACTIVITY_STATISTICS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        GetActivityStatisticsParamDTO getActivityStatisticsParamDTO = new GetActivityStatisticsParamDTO();
        getActivityStatisticsParamDTO.setActivityCode(activityCode);
        getActivityStatisticsParamDTO.setUserId(userId);
        HttpEntity httpEntity = new HttpEntity(getActivityStatisticsParamDTO, headers);

        log.info("getActivityStatistics httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<ActivityStatisticsDTO>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<ActivityStatisticsDTO>>() {
                });
        log.info("getActivityStatistics respEntity:{}", respEntity.getBody().getResponseWithException(""));
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public UserStatisticsDTO getProcessingNum(String userId, String tenantId) {
        String url = envProperties.getAbtUri() + GET_PROCESSING_NUM;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        GetProcessingNumParamDTO getProcessingNumParamDTO = new GetProcessingNumParamDTO();
        getProcessingNumParamDTO.setTenantId(tenantId);
        getProcessingNumParamDTO.setUserId(userId);
        HttpEntity httpEntity = new HttpEntity(getProcessingNumParamDTO, headers);

        log.info("getProcessingNum httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<UserStatisticsDTO>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<UserStatisticsDTO>>() {
                });
        log.info("getProcessingNum respEntity:{}", respEntity.getBody().getResponseWithException(""));
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public List<ImportStatisticsDTO> getRecords(AuthoredUser user, String locale, Integer getRecordsNum, String activityName, String startTime, String endTime, String type, Integer state, Integer offset) {
        String url = envProperties.getAbtUri() + GET_RECORDS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        GetRecordsParamDTO getRecordsParamDTO = new GetRecordsParamDTO();
        getRecordsParamDTO.setUser(user);
        getRecordsParamDTO.setLocale(locale);
        getRecordsParamDTO.setGetRecordsNum(getRecordsNum);
        getRecordsParamDTO.setActivityName(activityName);
        getRecordsParamDTO.setStartTime(startTime);
        getRecordsParamDTO.setEndTime(endTime);
        getRecordsParamDTO.setType(type);
        getRecordsParamDTO.setState(state);
        getRecordsParamDTO.setOffset(offset);
        HttpEntity httpEntity = new HttpEntity(getRecordsParamDTO, headers);

        log.info("getRecords httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<List<ImportStatisticsDTO>>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<List<ImportStatisticsDTO>>>() {
                });
        log.info("getRecords respEntity:{}", respEntity.getBody().getStatus());
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public List<ExportStatisticsDTO> getExportRecords(AuthoredUser user, String locale, com.digiwin.athena.atdm.importstatistics.dto.GetRecordsParamDTO recordsParamDTO) {
        String url = envProperties.getAbtUri() + QUERY_EXPORT_RECORDS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        GetRecordsParamDTO getRecordsParamDTO = new GetRecordsParamDTO();
        getRecordsParamDTO.setOffset(recordsParamDTO.getOffset());
        getRecordsParamDTO.setUser(user);
        getRecordsParamDTO.setLocale(locale);
        getRecordsParamDTO.setGetRecordsNum(recordsParamDTO.getGetRecordsNum());
        getRecordsParamDTO.setType(recordsParamDTO.getType());
        getRecordsParamDTO.setTypes(recordsParamDTO.getTypes());
        getRecordsParamDTO.setState(recordsParamDTO.getState());
        getRecordsParamDTO.setStartTime(recordsParamDTO.getStartTime());
        getRecordsParamDTO.setEndTime(recordsParamDTO.getEndTime());
        getRecordsParamDTO.setActivityName(recordsParamDTO.getActivityName());
        getRecordsParamDTO.setFileName(recordsParamDTO.getFileName());
        HttpEntity httpEntity = new HttpEntity(getRecordsParamDTO, headers);

        log.info("getExportRecords httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<List<ExportStatisticsDTO>>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<List<ExportStatisticsDTO>>>() {
                });
        log.info("getExportRecords respEntity:{}", respEntity.getBody().getStatus());
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public UserStatisticsDTO getExportingNum(String userId, String tenantId, String type, List<String> types) {
        String url = envProperties.getAbtUri() + GET_EXPORTING_NUM;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        GetExportingNumParamDTO getExportingNumParamDTO = new GetExportingNumParamDTO();
        getExportingNumParamDTO.setTenantId(tenantId);
        getExportingNumParamDTO.setUserId(userId);
        getExportingNumParamDTO.setType(type);
        getExportingNumParamDTO.setTypes(types);
        HttpEntity httpEntity = new HttpEntity(getExportingNumParamDTO, headers);

        log.info("getExportingNum httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<UserStatisticsDTO>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<UserStatisticsDTO>>() {
                });
        log.info("getExportingNum respEntity:{}", respEntity.getBody().getResponseWithException(""));
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public Boolean startDownload(DownloadBaseDataParamDTO downloadBaseDataParamDTO) {
        String url = envProperties.getAbtUri() + START_DOWNLOAD;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(downloadBaseDataParamDTO, headers);

        log.info("startDownload httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<Boolean>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<Boolean>>() {
                });
        log.info("startDownload respEntity:{}", respEntity.getBody().getResponseWithException(""));
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public ExportStatisticsDTO queryExportStatistics(DownloadExportFileParamDTO downloadExportFileParamDTO) {
        String url = envProperties.getAbtUri() + QUERY_EXPORT_STATISTICS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        QueryExportStatisticsParamDTO queryExportStatisticsParamDTO = new QueryExportStatisticsParamDTO();
        queryExportStatisticsParamDTO.setMasterId(downloadExportFileParamDTO.getMasterId());
        HttpEntity httpEntity = new HttpEntity(queryExportStatisticsParamDTO, headers);

        log.info("queryExportStatistics httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<ExportStatisticsDTO>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<ExportStatisticsDTO>>() {
                });
        log.info("queryExportStatistics respEntity:{}", respEntity.getBody().getResponseWithException(""));
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public void updateRetryDownloadState(String masterId) {
        String url = envProperties.getAbtUri() + UPDATE_RETRY_DOWNLOAD_STATE + "?masterId=" + masterId;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, String> params = new HashMap<>();
        HttpEntity httpEntity = new HttpEntity(params, headers);

        log.info("updateRetryDownloadState httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<ExportStatisticsDTO>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<ExportStatisticsDTO>>() {
                });
        log.info("updateRetryDownloadState respEntity:{}", respEntity.getBody().getResponseWithException(""));
    }

    @Override
    public ExportHeaderRespDTO getTableHeader(String actionId) {
        String url = envProperties.getAbtUri() + GET_TABLE_HEADERS + actionId;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, String> params = new HashMap<>();
        HttpEntity httpEntity = new HttpEntity(params, headers);

        log.info("getTableHeader httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<ExportHeaderRespDTO>> respEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<ExportHeaderRespDTO>>() {
                });
        log.info("getTableHeader respEntity:{}", respEntity.getBody().getResponseWithException(""));
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public void uploadAsync(List<UploadParamDTO> uploadParamDTO) {
        String url = envProperties.getAbtUri() + UPLOAD_ASYNC;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(uploadParamDTO, headers);

        log.info("updateRetryDownloadState httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<Object>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<Object>>() {
                });
        log.info("updateRetryDownloadState respEntity:{}", respEntity.getBody().getResponseWithException(""));
    }


    @Override
    public List<BatchImportListRespDTO> getImportBasicDataList() {
        String url = envProperties.getAbtUri() + IMPORT_BASIC_DATA_LIST;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(null, headers);

        log.info("import-basicDataList httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<List<BatchImportListRespDTO>>> respEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<List<BatchImportListRespDTO>>>() {
                });
        log.info("import-basicDataList respEntity:{}", Objects.requireNonNull(respEntity.getBody()).getResponseWithException(""));
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public List<ExportBasicDataRespDTO> getExportBasicDataList() {
        String url = envProperties.getAbtUri() + EXPORT_BASIC_DATA_LIST;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(null, headers);

        log.info("import-basicDataList httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<List<ExportBasicDataRespDTO>>> respEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<List<ExportBasicDataRespDTO>>>() {
                });
        log.info("import-basicDataList respEntity:{}", Objects.requireNonNull(respEntity.getBody()).getResponseWithException(""));
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public Boolean startDownloadHistoryData(DownloadHistoryProjectTaskParamDTO downloadHistoryProjectTaskParamDTO) {
        String url = envProperties.getAbtUri() + START_DOWNLOAD_HISTORY_DATA;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(downloadHistoryProjectTaskParamDTO, headers);

        log.info("startDownloadHistoryData httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO<Boolean>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<Boolean>>() {
                });
        log.info("startDownloadHistoryData respEntity:{}", respEntity.getBody().getResponseWithException(""));
        return respEntity.getBody().getResponseWithException("");
    }
}
