/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.manager.abt.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.dto.ActivityStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.BatchImportListRespDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadBaseDataParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadExportFileParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadHistoryProjectTaskParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadTemplateDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ErrorTableDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ExportBasicDataRespDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ExportHeaderRespDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ExportStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ImportStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.UploadParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.UserStatisticsDTO;
import com.digiwin.athena.base.infrastructure.config.EnvProperties;
import com.digiwin.athena.base.infrastructure.manager.abt.AbtService;
import com.digiwin.athena.base.infrastructure.manager.abt.model.DownloadTemplateParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.GetActivityStatisticsParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.GetErrorTableParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.GetExportingNumParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.GetProcessingNumParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.GetRecordsParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.QueryExportStatisticsParamDTO;
import com.digiwin.athena.base.infrastructure.manager.abt.model.QueryImportStatisticsParamDTO;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AbtServiceImpl
implements AbtService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbtServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    public static final String UPLOAD = "/api/abt/v1/baseDataEntry/upload";
    public static final String REPUBLISH = "/api/abt/v1/baseDataEntry/republish";
    public static final String REPUBLISH_ID = "/api/abt/v1/baseDataEntry/republishById";
    public static final String START_DOWNLOAD = "/api/abt/v1/baseDataEntry/startDownload";
    public static final String GET_IMPORT_STATISTICS = "/api/abt/v1/baseDataEntry/getImportStatistics";
    public static final String QUERY_EXPORT_STATISTICS = "/api/abt/v1/baseDataEntry/queryExportStatistics";
    public static final String UPDATE_RETRY_DOWNLOAD_STATE = "/api/abt/v1/baseDataEntry/updateRetryDownloadState";
    public static final String UPLOAD_ASYNC = "/api/abt/v1/baseDataEntry/uploadAsync";
    public static final String IMPORT_BASIC_DATA_LIST = "/api/abt/v1/baseDataEntry/import/basicDataList";
    public static final String EXPORT_BASIC_DATA_LIST = "/api/abt/v1/baseDataEntry/export/basicDataList";
    public static final String GET_TABLE_HEADERS = "/api/abt/v1/baseDataEntry/getTableHeaders?actionId=";
    public static final String GET_ERROR_TABLE = "/api/abt/v1/baseDataEntry/getErrorTable";
    public static final String DOWNLOAD_TEMPLATE = "/api/abt/v1/baseDataEntry/downloadTemplate";
    public static final String DOWNLOAD_BASE_DATA = "/api/abt/v1/baseDataEntry/downloadBaseData";
    public static final String GET_ACTIVITY_STATISTICS = "/api/abt/v1/baseDataEntry/getActivityStatistics";
    public static final String GET_PROCESSING_NUM = "/api/abt/v1/baseDataEntry/getProcessingNum";
    public static final String GET_RECORDS = "/api/abt/v1/baseDataEntry/getRecords";
    public static final String QUERY_EXPORT_RECORDS = "/api/abt/v1/baseDataEntry/queryExportRecords";
    public static final String GET_EXPORTING_NUM = "/api/abt/v1/baseDataEntry/getExportingNum";
    public static final String START_DOWNLOAD_HISTORY_DATA = "/api/abt/v1/historyProjectTask/startDownloadHistoryData";

    @Override
    public void handleUpload(UploadParamDTO uploadParam, MultipartFile uploadFile) {
        HttpEntity fileEntity;
        if (Objects.isNull(uploadFile)) {
            log.error("uploadFile is null!");
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0078.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.fileEmpty", (Object[])new Object[0]));
        }
        String url = this.envProperties.getAbtUri() + UPLOAD;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpHeaders fileHeader = new HttpHeaders();
        fileHeader.setContentType(MediaType.parseMediaType((String)uploadFile.getContentType()));
        fileHeader.setContentDispositionFormData("file", uploadFile.getOriginalFilename());
        HttpHeaders fileInfoHeader = new HttpHeaders();
        fileInfoHeader.setContentType(MediaType.APPLICATION_JSON);
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        try {
            fileEntity = new HttpEntity((Object)new ByteArrayResource(uploadFile.getBytes()), (MultiValueMap)fileHeader);
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u4e0a\u4f20api\u5931\u8d25,e:{}", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0077.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.uploadError2", (Object[])new Object[0]));
        }
        HttpEntity uploadParamEntity = new HttpEntity((Object)uploadParam, (MultiValueMap)fileInfoHeader);
        multiValueMap.add((Object)"uploadParam", (Object)uploadParamEntity);
        multiValueMap.add((Object)"file", (Object)fileEntity);
        HttpEntity httpEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)headers);
        log.info("handleUpload httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, BaseResultDTO.class, new Object[0]);
        log.info("handleUpload respEntity:{}", (Object)((BaseResultDTO)respEntity.getBody()).getStatus());
    }

    @Override
    public void republish(UploadParamDTO uploadParamDTO) {
        String url = this.envProperties.getAbtUri() + REPUBLISH;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)uploadParamDTO, (MultiValueMap)headers);
        log.info("republish httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
        log.info("republish respEntity:{}", (Object)((BaseResultDTO)respEntity.getBody()).getStatus());
    }

    @Override
    public ImportStatisticsDTO queryImportStatistics(String masterId) {
        String url = this.envProperties.getAbtUri() + GET_IMPORT_STATISTICS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        QueryImportStatisticsParamDTO queryImportStatisticsParamDTO = new QueryImportStatisticsParamDTO();
        queryImportStatisticsParamDTO.setMasterId(masterId);
        HttpEntity httpEntity = new HttpEntity((Object)queryImportStatisticsParamDTO, (MultiValueMap)headers);
        log.info("queryImportStatistics httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<ImportStatisticsDTO>>(){}, new Object[0]);
        log.info("queryImportStatistics respEntity:{}", ((BaseResultDTO)respEntity.getBody()).getResponseWithException(""));
        return (ImportStatisticsDTO)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public ErrorTableDTO getErrorTable(String masterId, String locale) {
        String url = this.envProperties.getAbtUri() + GET_ERROR_TABLE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        GetErrorTableParamDTO getErrorTableParamDTO = new GetErrorTableParamDTO();
        getErrorTableParamDTO.setMasterId(masterId);
        getErrorTableParamDTO.setLocale(locale);
        HttpEntity httpEntity = new HttpEntity((Object)getErrorTableParamDTO, (MultiValueMap)headers);
        log.info("getErrorTable httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<ErrorTableDTO>>(){}, new Object[0]);
        log.info("getErrorTable respEntity:{}", (Object)((BaseResultDTO)respEntity.getBody()).getStatus());
        return (ErrorTableDTO)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public byte[] downloadTemplate(String actionId, String token, String locale, DownloadTemplateDTO downloadTemplateDTO) {
        String url = this.envProperties.getAbtUri() + DOWNLOAD_TEMPLATE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        DownloadTemplateParamDTO downloadTemplateParamDTO = new DownloadTemplateParamDTO();
        downloadTemplateParamDTO.setActionId(actionId);
        downloadTemplateParamDTO.setToken(token);
        downloadTemplateParamDTO.setLocale(locale);
        downloadTemplateParamDTO.setDownloadTemplateDTO(downloadTemplateDTO);
        HttpEntity httpEntity = new HttpEntity((Object)downloadTemplateParamDTO, (MultiValueMap)headers);
        log.info("downloadTemplate httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<byte[]>>(){}, new Object[0]);
        log.info("downloadTemplate respEntity:{}", (Object)((BaseResultDTO)respEntity.getBody()).getStatus());
        return (byte[])((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public byte[] downloadBaseData(DownloadBaseDataParamDTO downloadBaseDataParamDTO) {
        String url = this.envProperties.getAbtUri() + DOWNLOAD_BASE_DATA;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)downloadBaseDataParamDTO, (MultiValueMap)headers);
        log.info("downloadBaseData httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<byte[]>>(){}, new Object[0]);
        log.info("downloadBaseData respEntity:{}", (Object)((BaseResultDTO)respEntity.getBody()).getStatus());
        return (byte[])((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public ActivityStatisticsDTO getActivityStatistics(String activityCode, String userId) {
        String url = this.envProperties.getAbtUri() + GET_ACTIVITY_STATISTICS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        GetActivityStatisticsParamDTO getActivityStatisticsParamDTO = new GetActivityStatisticsParamDTO();
        getActivityStatisticsParamDTO.setActivityCode(activityCode);
        getActivityStatisticsParamDTO.setUserId(userId);
        HttpEntity httpEntity = new HttpEntity((Object)getActivityStatisticsParamDTO, (MultiValueMap)headers);
        log.info("getActivityStatistics httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<ActivityStatisticsDTO>>(){}, new Object[0]);
        log.info("getActivityStatistics respEntity:{}", ((BaseResultDTO)respEntity.getBody()).getResponseWithException(""));
        return (ActivityStatisticsDTO)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public UserStatisticsDTO getProcessingNum(String userId, String tenantId) {
        String url = this.envProperties.getAbtUri() + GET_PROCESSING_NUM;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        GetProcessingNumParamDTO getProcessingNumParamDTO = new GetProcessingNumParamDTO();
        getProcessingNumParamDTO.setTenantId(tenantId);
        getProcessingNumParamDTO.setUserId(userId);
        HttpEntity httpEntity = new HttpEntity((Object)getProcessingNumParamDTO, (MultiValueMap)headers);
        log.info("getProcessingNum httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<UserStatisticsDTO>>(){}, new Object[0]);
        log.info("getProcessingNum respEntity:{}", ((BaseResultDTO)respEntity.getBody()).getResponseWithException(""));
        return (UserStatisticsDTO)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public List<ImportStatisticsDTO> getRecords(AuthoredUser user, String locale, Integer getRecordsNum, String activityName, String startTime, String endTime, String type, Integer state, Integer offset) {
        String url = this.envProperties.getAbtUri() + GET_RECORDS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        GetRecordsParamDTO getRecordsParamDTO = new GetRecordsParamDTO();
        getRecordsParamDTO.setUser(user);
        getRecordsParamDTO.setLocale(locale);
        getRecordsParamDTO.setGetRecordsNum(getRecordsNum);
        getRecordsParamDTO.setActivityName(activityName);
        getRecordsParamDTO.setStartTime(startTime);
        getRecordsParamDTO.setEndTime(endTime);
        getRecordsParamDTO.setType(type);
        getRecordsParamDTO.setState(state);
        getRecordsParamDTO.setOffset(offset);
        HttpEntity httpEntity = new HttpEntity((Object)getRecordsParamDTO, (MultiValueMap)headers);
        log.info("getRecords httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<ImportStatisticsDTO>>>(){}, new Object[0]);
        log.info("getRecords respEntity:{}", (Object)((BaseResultDTO)respEntity.getBody()).getStatus());
        return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public List<ExportStatisticsDTO> getExportRecords(AuthoredUser user, String locale, com.digiwin.athena.atdm.importstatistics.dto.GetRecordsParamDTO recordsParamDTO) {
        String url = this.envProperties.getAbtUri() + QUERY_EXPORT_RECORDS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        GetRecordsParamDTO getRecordsParamDTO = new GetRecordsParamDTO();
        getRecordsParamDTO.setOffset(recordsParamDTO.getOffset());
        getRecordsParamDTO.setUser(user);
        getRecordsParamDTO.setLocale(locale);
        getRecordsParamDTO.setGetRecordsNum(recordsParamDTO.getGetRecordsNum());
        getRecordsParamDTO.setType(recordsParamDTO.getType());
        getRecordsParamDTO.setTypes(recordsParamDTO.getTypes());
        getRecordsParamDTO.setState(recordsParamDTO.getState());
        getRecordsParamDTO.setStartTime(recordsParamDTO.getStartTime());
        getRecordsParamDTO.setEndTime(recordsParamDTO.getEndTime());
        getRecordsParamDTO.setActivityName(recordsParamDTO.getActivityName());
        getRecordsParamDTO.setFileName(recordsParamDTO.getFileName());
        HttpEntity httpEntity = new HttpEntity((Object)getRecordsParamDTO, (MultiValueMap)headers);
        log.info("getExportRecords httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<ExportStatisticsDTO>>>(){}, new Object[0]);
        log.info("getExportRecords respEntity:{}", (Object)((BaseResultDTO)respEntity.getBody()).getStatus());
        return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public UserStatisticsDTO getExportingNum(String userId, String tenantId, String type, List<String> types) {
        String url = this.envProperties.getAbtUri() + GET_EXPORTING_NUM;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        GetExportingNumParamDTO getExportingNumParamDTO = new GetExportingNumParamDTO();
        getExportingNumParamDTO.setTenantId(tenantId);
        getExportingNumParamDTO.setUserId(userId);
        getExportingNumParamDTO.setType(type);
        getExportingNumParamDTO.setTypes(types);
        HttpEntity httpEntity = new HttpEntity((Object)getExportingNumParamDTO, (MultiValueMap)headers);
        log.info("getExportingNum httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<UserStatisticsDTO>>(){}, new Object[0]);
        log.info("getExportingNum respEntity:{}", ((BaseResultDTO)respEntity.getBody()).getResponseWithException(""));
        return (UserStatisticsDTO)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public Boolean startDownload(DownloadBaseDataParamDTO downloadBaseDataParamDTO) {
        String url = this.envProperties.getAbtUri() + START_DOWNLOAD;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)downloadBaseDataParamDTO, (MultiValueMap)headers);
        log.info("startDownload httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, new Object[0]);
        log.info("startDownload respEntity:{}", ((BaseResultDTO)respEntity.getBody()).getResponseWithException(""));
        return (Boolean)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public ExportStatisticsDTO queryExportStatistics(DownloadExportFileParamDTO downloadExportFileParamDTO) {
        String url = this.envProperties.getAbtUri() + QUERY_EXPORT_STATISTICS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        QueryExportStatisticsParamDTO queryExportStatisticsParamDTO = new QueryExportStatisticsParamDTO();
        queryExportStatisticsParamDTO.setMasterId(downloadExportFileParamDTO.getMasterId());
        HttpEntity httpEntity = new HttpEntity((Object)queryExportStatisticsParamDTO, (MultiValueMap)headers);
        log.info("queryExportStatistics httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<ExportStatisticsDTO>>(){}, new Object[0]);
        log.info("queryExportStatistics respEntity:{}", ((BaseResultDTO)respEntity.getBody()).getResponseWithException(""));
        return (ExportStatisticsDTO)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public void updateRetryDownloadState(String masterId) {
        String url = this.envProperties.getAbtUri() + UPDATE_RETRY_DOWNLOAD_STATE + "?masterId=" + masterId;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap params = new HashMap();
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        log.info("updateRetryDownloadState httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<ExportStatisticsDTO>>(){}, new Object[0]);
        log.info("updateRetryDownloadState respEntity:{}", ((BaseResultDTO)respEntity.getBody()).getResponseWithException(""));
    }

    @Override
    public ExportHeaderRespDTO getTableHeader(String actionId) {
        String url = this.envProperties.getAbtUri() + GET_TABLE_HEADERS + actionId;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap params = new HashMap();
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        log.info("getTableHeader httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<ExportHeaderRespDTO>>(){}, new Object[0]);
        log.info("getTableHeader respEntity:{}", ((BaseResultDTO)respEntity.getBody()).getResponseWithException(""));
        return (ExportHeaderRespDTO)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public void uploadAsync(List<UploadParamDTO> uploadParamDTO) {
        String url = this.envProperties.getAbtUri() + UPLOAD_ASYNC;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(uploadParamDTO, (MultiValueMap)headers);
        log.info("updateRetryDownloadState httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Object>>(){}, new Object[0]);
        log.info("updateRetryDownloadState respEntity:{}", ((BaseResultDTO)respEntity.getBody()).getResponseWithException(""));
    }

    @Override
    public List<BatchImportListRespDTO> getImportBasicDataList() {
        String url = this.envProperties.getAbtUri() + IMPORT_BASIC_DATA_LIST;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        log.info("import-basicDataList httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<BatchImportListRespDTO>>>(){}, new Object[0]);
        log.info("import-basicDataList respEntity:{}", ((BaseResultDTO)Objects.requireNonNull(respEntity.getBody())).getResponseWithException(""));
        return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public List<ExportBasicDataRespDTO> getExportBasicDataList() {
        String url = this.envProperties.getAbtUri() + EXPORT_BASIC_DATA_LIST;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        log.info("import-basicDataList httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<ExportBasicDataRespDTO>>>(){}, new Object[0]);
        log.info("import-basicDataList respEntity:{}", ((BaseResultDTO)Objects.requireNonNull(respEntity.getBody())).getResponseWithException(""));
        return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public Boolean startDownloadHistoryData(DownloadHistoryProjectTaskParamDTO downloadHistoryProjectTaskParamDTO) {
        String url = this.envProperties.getAbtUri() + START_DOWNLOAD_HISTORY_DATA;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)downloadHistoryProjectTaskParamDTO, (MultiValueMap)headers);
        log.info("startDownloadHistoryData httpEntity\uff1a{}", httpEntity.getBody());
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, new Object[0]);
        log.info("startDownloadHistoryData respEntity:{}", ((BaseResultDTO)respEntity.getBody()).getResponseWithException(""));
        return (Boolean)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }
}

