package com.digiwin.athena.atdm.importstatistics.util.excel;

import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @ClassName ExcelHellper
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/9 17:49
 * @Version 1.0
 **/
@Slf4j
@SuppressWarnings({"findsecbugs:PATH_TRAVERSAL_IN"})
public class ExcelHellper {
    /**
     * 给Cell添加批注
     *
     * @param cell      单元格
     * @param value     批注内容
     * @param extension 扩展名
     */
    public static void addComment(Cell cell, String value, String extension) {
        Sheet sheet = cell.getSheet();
        cell.removeCellComment();
        if (".xls".equals(extension)) {
            ClientAnchor anchor = new HSSFClientAnchor();
            // 关键修改
            anchor.setDx1(0);
            anchor.setDx2(0);
            anchor.setDy1(0);
            anchor.setDy2(0);
            anchor.setCol1(cell.getColumnIndex());
            anchor.setRow1(cell.getRowIndex());
            anchor.setCol2(cell.getColumnIndex() + 5);
            anchor.setRow2(cell.getRowIndex() + 6);
            // 结束
            Drawing drawing = sheet.createDrawingPatriarch();
            Comment comment = drawing.createCellComment(anchor);
            // 输入批注信息
            comment.setString(new HSSFRichTextString(value));
            // 将批注添加到单元格对象中
            cell.setCellComment(comment);
        } else if (".xlsx".equals(extension)) {
            ClientAnchor anchor = new XSSFClientAnchor();
            // 关键修改
            anchor.setDx1(0);
            anchor.setDx2(0);
            anchor.setDy1(0);
            anchor.setDy2(0);
            anchor.setCol1(cell.getColumnIndex());
            anchor.setRow1(cell.getRowIndex());
            anchor.setCol2(cell.getColumnIndex() + 5);
            anchor.setRow2(cell.getRowIndex() + 6);
            // 结束
            Drawing drawing = sheet.createDrawingPatriarch();
            Comment comment = drawing.createCellComment(anchor);
            // 输入批注信息
            comment.setString(new XSSFRichTextString(value));
            // 将批注添加到单元格对象中
            cell.setCellComment(comment);
        }
    }

    public String getCellFromExcel(String path, String row, String col) throws Exception {
        return getCellFromExcel(path, 0, Integer.valueOf(row), Integer.valueOf(col));
    }

    public String getRowFromExcel(String path, String row) throws Exception {
        return getRowFromExcel(path, 0, Integer.valueOf(row));
    }

    public String getRowFromExcel(String path, int sheet, int row) throws Exception {
        File xlsx = new File(path);
        Workbook workbook = WorkbookFactory.create(xlsx);
        Sheet sheet1 = workbook.getSheetAt(sheet);
        Row row1 = sheet1.getRow(row);
        List<String> list = new ArrayList<>();
        int rowNum = row1.getLastCellNum();
        for (int i = 0; i < rowNum; i++) {
            list.add(getCellValueByCell(row1.getCell(i)));
        }
        log.info("文件名：{}，sheet：{}，row：{}，取值：{}", path, sheet, row, list.toString());
        return list.toString();
    }


    public String getCellFromExcel(String path, int sheet, int row, int col) throws Exception {
        File xlsx = new File(path);
        Workbook workbook = WorkbookFactory.create(xlsx);
        Sheet sheet1 = workbook.getSheetAt(sheet);
        Row row1 = sheet1.getRow(row);
        String cell = getCellValueByCell(row1.getCell(col));
        log.info("文件名：{}，sheet：{}，row：{}，col：{}，取值：{}", path, sheet, row, col, cell);
        return cell;
    }

    //获取单元格各类型值，返回字符串类型
    private static String getCellValueByCell(Cell cell) {
        //判断是否为null或空串
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String cellValue = "";
        CellType cellType = cell.getCellType();

        switch (cellType) {
            case NUMERIC: // 数字
                if (HSSFDateUtil.isCellDateFormatted(cell)) { // 日期
                    Date date = cell.getDateCellValue();
                    DateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    cellValue = formater.format(date);
                } else {
                    // 去掉小数点后多余的 .0
                    double value = cell.getNumericCellValue();
                    if (value == (long) value) {
                        cellValue = String.valueOf((long) value);
                    } else {
                        cellValue = String.valueOf(value);
                    }
                }
                break;

            case STRING: // 字符串
                cellValue = cell.getStringCellValue();
                break;

            case BOOLEAN: // Boolean
                cellValue = String.valueOf(cell.getBooleanCellValue());
                break;

            case FORMULA: // 公式
                try {
                    // 尝试直接计算公式结果
                    cellValue = String.valueOf(cell.getNumericCellValue());
                } catch (Exception e) {
                    // 如果公式不是数值型，直接取表达式
                    cellValue = cell.getCellFormula();
                }
                break;

            case BLANK: // 空值
                cellValue = "";
                break;

            case ERROR: // 错误
                cellValue = MessageUtil.getMessage("delivery.invalidStr");
                break;

            default:
                cellValue = MessageUtil.getMessage("delivery.unknowType");
                break;
        }
        return cellValue;
    }
}
